/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.Java2ProcessExec;
import com.installshield.util.ProcessExecException;
import com.installshield.util.ProcessOutputHandler;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class ProcessExec {
    public static final int NOT_STARTED = 0;
    public static final int STARTED = 1;
    public static final int FINISHED = 2;
    public static final int ERROR = 3;
    public String tempOutputFilename;
    private long processExecDelay = 500L;
    private String command = "";
    private String[] arguments = new String[0];
    public String outputDestination = null;
    public String errDestination = null;
    private ProcessOutputHandler outputHandler = null;
    private String[] createdDirsAndFiles = new String[0];
    private Process process;
    private ProcessStatus processStatus = new ProcessStatus();
    private final int CAPTURE_OUTPUT = 0;
    private final int CAPTURE_ERROR = 1;
    private int exitCode;
    private int status = 0;

    public ProcessExec(String command) {
        this(command, null);
    }

    public ProcessExec(String command, String[] args) {
        this(command, args, null, null);
    }

    public ProcessExec(String command, String[] args, String outputDestination, String errDestination) {
        this.command = command;
        if (args != null) {
            this.arguments = new String[args.length];
            System.arraycopy(args, 0, this.arguments, 0, args.length);
        }
        this.outputDestination = outputDestination;
        this.errDestination = errDestination;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public void setArguments(String[] args) {
        this.arguments = args;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setProcessExecDelay(long delay) {
        if (delay >= 0L) {
            this.processExecDelay = delay;
        }
    }

    public String[] getCreatedDirectories() {
        return this.createdDirsAndFiles;
    }

    public void setProcessOutputHandler(ProcessOutputHandler handler) {
        this.outputHandler = handler;
    }

    public void executeProcess() throws ProcessExecException {
        try {
            String[] commandArry = new String[this.arguments.length + 1];
            commandArry[0] = this.command;
            System.arraycopy(this.arguments, 0, commandArry, 1, this.arguments.length);
            File testf = new File(commandArry[0]);
            try {
                Class.forName("java.awt.Robot");
                Class<?> newProcessExec = Class.forName("com.installshield.util.Java2ProcessExec");
                Java2ProcessExec j2PExec = (Java2ProcessExec)newProcessExec.newInstance();
                this.process = j2PExec.processExec(commandArry, new File(testf.getParent()));
            }
            catch (Exception e) {
                this.process = Runtime.getRuntime().exec(commandArry);
            }
            this.status = 1;
            try {
                Thread.sleep(this.processExecDelay);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            this.processStatus.setProcessStarted();
            if (this.outputHandler == null) {
                this.outputHandler = new DefaultProcessOutputHandler();
            }
            ProcessOutputThread pot = new ProcessOutputThread(this.process.getInputStream(), 0);
            ProcessOutputThread pet = new ProcessOutputThread(this.process.getErrorStream(), 1);
            pot.start();
            pet.start();
            this.process.waitFor();
            pot.join();
            pet.join();
            this.exitCode = this.process.exitValue();
            this.status = 2;
        }
        catch (Exception e) {
            this.status = 3;
            throw new ProcessExecException(e.getMessage());
        }
        finally {
            try {
                if (this.process.getInputStream() != null) {
                    this.process.getInputStream().close();
                }
                if (this.process.getErrorStream() != null) {
                    this.process.getErrorStream().close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public void destroy() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    private synchronized void updateCreatedDirsAndFiles(String[] dirs) {
        if (dirs != null) {
            String[] tmp = this.createdDirsAndFiles;
            this.createdDirsAndFiles = new String[this.createdDirsAndFiles.length + dirs.length];
            System.arraycopy(tmp, 0, this.createdDirsAndFiles, 0, tmp.length);
            System.arraycopy(dirs, 0, this.createdDirsAndFiles, tmp.length, dirs.length);
        }
    }

    public synchronized boolean getProcessStarted() {
        return this.processStatus.getProcessStarted();
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public int getStatus() {
        return this.status;
    }

    class DefaultProcessOutputHandler
    implements ProcessOutputHandler {
        DefaultProcessOutputHandler() {
        }

        public void processOutputData(InputStream ipStream) {
            if (ProcessExec.this.outputDestination != null) {
                this.writeData(ipStream, ProcessExec.this.outputDestination);
            } else {
                this.writeData(ipStream, null);
            }
        }

        public void processErrorData(InputStream ipStream) {
            if (ProcessExec.this.errDestination != null) {
                this.writeData(ipStream, ProcessExec.this.errDestination);
            } else {
                this.writeData(ipStream);
            }
        }

        private void writeData(InputStream ipStream) {
            try {
                byte[] data = new byte[1024];
                while (ipStream.read(data) != -1) {
                    Thread.sleep(10L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeData(InputStream ipStream, String destination) {
            InputStreamReader reader = null;
            CharArrayWriter cWriter = null;
            OutputStreamWriter osWriter = null;
            try {
                osWriter = this.createOutputStreamWriter(destination);
                reader = new InputStreamReader(ipStream);
                char[] data = new char[1024];
                int count = 0;
                cWriter = new CharArrayWriter();
                while ((count = reader.read(data, 0, data.length)) != -1) {
                    cWriter.write(data, 0, count);
                }
                if (osWriter != null) {
                    cWriter.writeTo(osWriter);
                    osWriter.close();
                } else {
                    System.out.print(cWriter.toCharArray());
                }
                cWriter.close();
            }
            catch (Exception e) {
            }
            finally {
                try {
                    cWriter.close();
                }
                catch (Exception e) {}
            }
        }

        private synchronized OutputStreamWriter createOutputStreamWriter(String destination) {
            int index;
            OutputStreamWriter osWriter = null;
            if (destination != null && destination.length() > 0 && (index = (destination = CoreFileUtils.normalizeFileName(destination, '/')).lastIndexOf("/")) != -1) {
                File file = new File(destination.substring(0, index + 1));
                try {
                    String[] dirs = CoreFileUtils.createDirs(file);
                    ProcessExec.this.updateCreatedDirsAndFiles(dirs);
                    ProcessExec.this.updateCreatedDirsAndFiles(new String[]{destination});
                    osWriter = new OutputStreamWriter(new FileOutputStream(new File(destination)));
                }
                catch (Exception ex) {
                    osWriter = null;
                }
            }
            return osWriter;
        }
    }

    class ProcessStatus {
        boolean processStarted = false;

        ProcessStatus() {
        }

        public synchronized void setProcessStarted() {
            this.processStarted = true;
        }

        public synchronized boolean getProcessStarted() {
            return this.processStarted;
        }
    }

    class ProcessOutputThread
    extends Thread {
        private int type = -1;
        private InputStream stream = null;

        public ProcessOutputThread(InputStream stream, int type) {
            this.type = type;
            this.stream = stream;
        }

        public void run() {
            if (this.stream != null && this.type == 0) {
                ProcessExec.this.outputHandler.processOutputData(this.stream);
            } else if (this.stream != null && this.type == 1) {
                ProcessExec.this.outputHandler.processErrorData(this.stream);
            }
        }

        public void setInputStream(InputStream stream) {
            this.stream = stream;
        }

        public int getType() {
            return this.type;
        }
    }
}

