/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.MD5;
import com.installshield.util.MetaInf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Dictionary;

public abstract class SecureMetaInf
extends MetaInf {
    private static final String DIGEST_KEY = "INF_ID";
    private byte[] key;

    public SecureMetaInf(byte[] key) {
        this.key = key;
    }

    public SecureMetaInf(URL source, byte[] key) throws IOException {
        this(source.openStream(), key);
    }

    public SecureMetaInf(InputStream in, byte[] key) throws IOException {
        this.key = key;
        this.read(this.getData(in));
    }

    public void read(Dictionary data) throws IOException {
        this.readObject(data);
        boolean verified = false;
        String digestKey = (String)data.get(DIGEST_KEY);
        try {
            if (digestKey != null && this.createDigest().equals(digestKey)) {
                verified = true;
            }
        }
        catch (Exception genErr) {
            if (System.getProperty("is.debug") != null) {
                genErr.printStackTrace();
            }
            verified = false;
        }
        if (!verified) {
            throw new IOException("file has changed since it was created");
        }
    }

    public void write(OutputStream out) throws IOException {
        PrintWriter writer = new PrintWriter(out, true);
        this.writeDigest(writer);
        this.writeObject(writer);
    }

    private void writeDigest(PrintWriter writer) throws IOException {
        writer.println("INF_ID: " + this.createDigest());
    }

    private String createDigest() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(bytesOut, true);
        this.writeObjectDigest(writer);
        writer.flush();
        MD5 md5 = new MD5();
        md5.write(bytesOut.toByteArray());
        md5.write(this.key);
        writer.close();
        bytesOut.close();
        return MD5.toHex(md5.toHash());
    }

    protected abstract void readObject(Dictionary var1) throws IOException;

    protected abstract void writeObject(PrintWriter var1) throws IOException;

    protected abstract void writeObjectDigest(PrintWriter var1) throws IOException;
}

