/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class StringUtils {
    public static String[] parseCommaDelimitedString(String stringToParse) {
        return StringUtils.parseDelimitedString(stringToParse, ",");
    }

    public static String createDelimitedString(String[] args, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (buffer.length() > 0) {
                    buffer.append(delimiter);
                }
                buffer.append(args[i]);
            }
        }
        return buffer.toString();
    }

    public static String createCommaDelimitedString(String[] args) {
        return StringUtils.createDelimitedString(args, ",");
    }

    public static String[] parseDelimitedString(String stringToParse, String delimiter) {
        String[] parsedStrings = new String[]{};
        if (stringToParse != null) {
            StringTokenizer tokens = new StringTokenizer(stringToParse, delimiter);
            parsedStrings = new String[tokens.countTokens()];
            int i = 0;
            while (tokens.hasMoreTokens()) {
                parsedStrings[i++] = tokens.nextToken();
            }
        }
        return parsedStrings;
    }

    public static boolean isWhitespace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsWhitespace(String s) {
        int index = s.indexOf(" ");
        return index != -1;
    }

    public static String replace(String str, String find, String replaceWith) {
        if (str == null || str.length() == 0 || find == null || find.length() == 0 || replaceWith == null || find.equals(replaceWith)) {
            return str;
        }
        int findLen = find.length();
        int strLen = str.length();
        int i = 0;
        boolean done = false;
        StringBuffer buf = new StringBuffer(strLen);
        while (!done && i < strLen) {
            int index = str.indexOf(find, i);
            if (index < 0) {
                buf.append(str.substring(i));
                done = true;
                continue;
            }
            buf.append(str.substring(i, index));
            buf.append(replaceWith);
            i = index + findLen;
        }
        return buf.toString();
    }

    public static String createString(char c, int count) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            buf.append(c);
        }
        return buf.toString();
    }

    public static int compareVersionStrings(String ver1, String ver2) {
        String[] ver1Tokens = StringUtils.parseDelimitedString(ver1, ".");
        String[] ver2Tokens = StringUtils.parseDelimitedString(ver2, ".");
        for (int i = 0; i < ver1Tokens.length; ++i) {
            String ver1Token = ver1Tokens[i];
            try {
                String ver2Token = ver2Tokens[i];
                int compareVal = ver1Token.compareToIgnoreCase(ver2Token);
                if (compareVal == 0) continue;
                return compareVal;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return ver1Tokens.length - ver2Tokens.length;
            }
        }
        if (ver2Tokens.length > ver1Tokens.length) {
            return ver1Tokens.length - ver2Tokens.length;
        }
        return 0;
    }

    private static String translateToGNUPattern(String pattern) {
        StringBuffer buf = new StringBuffer();
        boolean quoting = false;
        for (int i = 0; i < pattern.length(); ++i) {
            if (pattern.charAt(i) != '*' && pattern.charAt(i) != '?' && pattern.charAt(i) != '\\') {
                if (!quoting) {
                    buf.append("\\Q");
                    quoting = true;
                }
                buf.append(pattern.charAt(i));
            } else if (pattern.charAt(i) == '\\') {
                if (quoting) {
                    buf.append("\\E");
                    quoting = false;
                }
                buf.append('\\');
                buf.append('\\');
            } else if (pattern.charAt(i) == '*') {
                if (quoting) {
                    buf.append("\\E");
                    quoting = false;
                }
                buf.append('.');
                buf.append('*');
            } else if (pattern.charAt(i) == '?') {
                if (quoting) {
                    buf.append("\\E");
                    quoting = false;
                }
                buf.append('.');
            }
            if (!quoting || i != pattern.length() - 1) continue;
            buf.append("\\E");
        }
        return buf.toString();
    }

    public static boolean findPattern(String value, String pattern) {
        try {
            Pattern pat = Pattern.compile(pattern);
            Matcher matcher = pat.matcher(value);
            return matcher.find();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    public static boolean matchPattern(String value, String pattern, boolean useGNU) throws PatternSyntaxException {
        StringTokenizer tok = new StringTokenizer(pattern, ";", false);
        boolean patternMatches = false;
        while (!patternMatches && tok.hasMoreTokens()) {
            String currPattern = tok.nextToken().trim();
            if (currPattern == null || currPattern.length() <= 0) continue;
            if (useGNU) {
                patternMatches = Pattern.matches(currPattern, value);
                continue;
            }
            patternMatches = Pattern.matches(StringUtils.translateToGNUPattern(currPattern) + "$", value);
        }
        return patternMatches;
    }
}

