/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.MD5;
import java.net.InetAddress;

public class UID {
    private static byte[] ip = null;

    public static void main(String[] args) {
        int count = 1;
        if (args.length > 0) {
            try {
                count = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        for (int i = 0; i < count; ++i) {
            System.out.println(UID.createUIDAsString());
        }
    }

    public static byte[] createUID() {
        if (ip == null) {
            try {
                ip = InetAddress.getLocalHost().getAddress();
            }
            catch (Throwable th) {
                ip = new byte[4];
                for (int i = 0; i < ip.length; ++i) {
                    UID.ip[i] = (byte)(Math.random() * 255.0);
                }
            }
        }
        byte[] time = UID.getTime();
        byte[] rand = UID.getRand(8);
        MD5 md5 = new MD5();
        md5.write(ip);
        md5.write(time);
        md5.write(rand);
        return md5.toHash();
    }

    public static String createUIDAsString() {
        return MD5.toHex(UID.createUID());
    }

    private static byte[] getTime() {
        long time = System.currentTimeMillis();
        byte[] ret = new byte[4];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)(time >> i * 8 & 0xFFL);
        }
        return ret;
    }

    private static byte[] getRand(int size) {
        byte[] ret = new byte[size];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)(Math.random() * 255.0);
        }
        return ret;
    }
}

