/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util.process;

import com.installshield.util.ProcessOutputHandler;
import java.io.PipedOutputStream;
import java.util.Vector;

public class ExecuteProcessSupport {
    private static final int NOT_STARTED = 0;
    private static final int STARTED = 1;
    private static final int FINISHED = 2;
    private static final int ERROR = 3;
    private String command = "";
    private String[] args = new String[0];
    private String stdOutDestination = "";
    private String stdErrDestination = "";
    private int procExitCode = -1;
    private int procStatus = 0;
    private boolean runNatively = false;
    private String username = "";
    private String password = "";
    private String workgroup = "";
    private Vector createdFilesAndDirs = new Vector();
    private PipedOutputStream stdOutOutputStream = new PipedOutputStream();
    private PipedOutputStream stdErrOutputStream = new PipedOutputStream();
    private ProcessOutputHandler procHandler = null;

    public ExecuteProcessSupport(String command, String[] args) {
        this(command, args, null, null);
    }

    public ExecuteProcessSupport(String command, String[] args, String stdOutDestination, String stdErrDestination) {
        this.command = command;
        this.args = args;
        this.stdOutDestination = stdOutDestination;
        this.stdErrDestination = stdErrDestination;
    }

    public String getCommand() {
        return this.command;
    }

    public String[] getArguments() {
        return this.args;
    }

    public String getArgumentString() {
        String ret = "";
        for (int i = 0; i < this.args.length; ++i) {
            ret = ret + this.args[i] + " ";
            ret = ret.trim();
        }
        return ret;
    }

    public String getStdOutDestination() {
        return this.stdOutDestination;
    }

    public String getStdErrDestination() {
        return this.stdErrDestination;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getWorkgroup() {
        return this.workgroup;
    }

    public void setWorkgroup(String workgroup) {
        this.workgroup = workgroup;
    }

    public boolean isRunNatively() {
        return this.runNatively;
    }

    public void setRunNatively(boolean runAsDifferentUser) {
        this.runNatively = runAsDifferentUser;
    }

    public boolean isProcessStarted() {
        return this.procStatus != 0;
    }

    public void setProcessStarted() {
        this.procStatus = 1;
    }

    public boolean isProcessFinished() {
        return this.procStatus == 2;
    }

    public void setProcessFinished() {
        this.procStatus = 2;
    }

    public void setProcessError() {
        this.procStatus = 3;
    }

    public boolean isProcessError() {
        return this.procStatus == 3;
    }

    public int getProcessReturnCode() {
        return this.procExitCode;
    }

    public void setProcessReturnCode(int exitCode) {
        this.procExitCode = exitCode;
    }

    public PipedOutputStream getStdErrorStream() {
        return this.stdErrOutputStream;
    }

    public PipedOutputStream getStdOutputStream() {
        return this.stdOutOutputStream;
    }

    public void addCreatedFileOrDirectory(String entry) {
        this.createdFilesAndDirs.addElement(entry);
    }

    public void addCreatedFilesOrDirectories(String[] entries) {
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                this.createdFilesAndDirs.addElement(entries[i]);
            }
        }
    }

    public String[] getCreatedFilesOrDirectories() {
        Object[] ret = new String[this.createdFilesAndDirs.size()];
        this.createdFilesAndDirs.copyInto(ret);
        return ret;
    }

    public void setProcessOutputHandler(ProcessOutputHandler procOutHandler) {
        this.procHandler = procOutHandler;
    }

    public ProcessOutputHandler getProcessOutputHandler() {
        return this.procHandler;
    }
}

