/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util.process;

import com.installshield.util.ProcessExecException;
import com.installshield.util.ProcessOutputHandler;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class ProcessOutputTask
implements Runnable {
    public static final int CAPTURE_OUTPUT = 0;
    public static final int CAPTURE_ERROR = 1;
    private PipedOutputStream procOutputStream = null;
    private ProcessOutputHandler procOutputHandler = null;
    private int type = -1;

    public ProcessOutputTask(PipedOutputStream procOutputStream, ProcessOutputHandler procOutputHandler, int type) {
        this.procOutputStream = procOutputStream;
        this.procOutputHandler = procOutputHandler;
        this.type = type;
    }

    public void run() {
        if (this.procOutputStream != null && this.procOutputHandler != null) {
            try {
                PipedInputStream pipedInput = new PipedInputStream(this.procOutputStream);
                switch (this.type) {
                    case 0: {
                        this.procOutputHandler.processOutputData(pipedInput);
                        break;
                    }
                    case 1: {
                        this.procOutputHandler.processErrorData(pipedInput);
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw new ProcessExecException(e);
            }
        }
    }
}

