/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util.sort;

import com.installshield.util.sort.ObjectCompare;

public class SortUtils {
    public static void qsort(Object[] items) {
        SortUtils.qsort(items, new ObjectCompare());
    }

    public static void qsort(Object[] items, ObjectCompare objectCompare) {
        SortUtils.qsort(items, objectCompare, 0, items.length - 1);
    }

    private static void qsort(Object[] items, ObjectCompare objectCompare, int low, int high) {
        if (high <= low) {
            return;
        }
        Object pivot = items[low];
        int i = low;
        int j = high + 1;
        while (j - i > 1) {
            while (i < j - 1 && !objectCompare.lessThan(pivot, items[i + 1])) {
                ++i;
            }
            while (j > i + 1 && objectCompare.lessThan(pivot, items[j - 1])) {
                --j;
            }
            if (j - i <= 1) continue;
            Object temp = items[j - 1];
            items[j - 1] = items[i + 1];
            items[i + 1] = temp;
            ++i;
            --j;
        }
        items[low] = items[i];
        items[i] = pivot;
        SortUtils.qsort(items, objectCompare, low, i - 1);
        SortUtils.qsort(items, objectCompare, j, high);
    }

    public static void mergeSort(Object[] items) {
        SortUtils.mergeSort(items, new ObjectCompare());
    }

    public static void mergeSort(Object[] items, ObjectCompare objectCompare) {
        SortUtils.mergeSort(items, objectCompare, 0, items.length);
    }

    private static void mergeSort(Object[] items, ObjectCompare objectCompare, int low, int high) {
        SortUtils.rangeCheck(items.length, low, high);
        Object[] aux = (Object[])items.clone();
        SortUtils.mergeSort(aux, items, objectCompare, low, high);
    }

    private static void mergeSort(Object[] src, Object[] dest, ObjectCompare objectCompare, int low, int high) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && objectCompare.compareTo(dest[j - 1], dest[j]) > 0; --j) {
                    SortUtils.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        SortUtils.mergeSort(dest, src, objectCompare, low, mid);
        SortUtils.mergeSort(dest, src, objectCompare, mid, high);
        if (objectCompare.compareTo(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && objectCompare.compareTo(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void rangeCheck(int arrayLen, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLen) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }
}

