/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.common.environment;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.regex.RegexUtil;
import com.installshield.wizard.platform.common.environment.ScriptEnvironmentVariableManager;
import com.zerog.interfaces.util.regex.RegExprSyntaxException;
import java.io.File;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class CShellManager
extends ScriptEnvironmentVariableManager {
    public CShellManager(String scriptFile) {
        super(scriptFile);
    }

    public String getCommentString() {
        return "#";
    }

    protected String writeVariable(String variableName, String valueWithEcho, String valueWithoutEcho) {
        StringBuffer buffer = new StringBuffer();
        if (valueWithEcho.equals(valueWithoutEcho)) {
            buffer.append("setenv").append(ScriptEnvironmentVariableManager.spaceSeparator).append(variableName).append(ScriptEnvironmentVariableManager.spaceSeparator).append(valueWithoutEcho).append(ScriptEnvironmentVariableManager.lineSeparator);
        } else {
            buffer.append("if ( $?" + variableName + " == 0 ) " + "then").append(ScriptEnvironmentVariableManager.lineSeparator);
            buffer.append("setenv").append(ScriptEnvironmentVariableManager.spaceSeparator).append(variableName).append(ScriptEnvironmentVariableManager.spaceSeparator).append(valueWithoutEcho).append(ScriptEnvironmentVariableManager.lineSeparator);
            buffer.append("else").append(ScriptEnvironmentVariableManager.lineSeparator);
            buffer.append("setenv").append(ScriptEnvironmentVariableManager.spaceSeparator).append(variableName).append(ScriptEnvironmentVariableManager.spaceSeparator).append(valueWithEcho).append(ScriptEnvironmentVariableManager.lineSeparator);
            buffer.append("endif").append(ScriptEnvironmentVariableManager.lineSeparator);
        }
        return buffer.toString();
    }

    protected String getEchoCommandString(String variableName) {
        return "`echo $" + variableName + "`";
    }

    protected String getBackupFileName(String parent, String file) {
        int backupNo = this.getCurrentBackupLevel(parent, file);
        return CoreFileUtils.createFileName(parent, file + "~" + backupNo + "~");
    }

    private int getCurrentBackupLevel(String parent, String file) {
        int max = 0;
        String rex = file + ".*";
        String[] files = new File(parent).list();
        Vector<String> filtered = new Vector<String>();
        try {
            for (int i = 0; i < files.length; ++i) {
                if (!RegexUtil.getInstance().matches(files[i], rex)) continue;
                filtered.addElement(files[i]);
            }
            Enumeration e = filtered.elements();
            StringTokenizer tokens = null;
            int backupNo = 0;
            while (e.hasMoreElements()) {
                tokens = new StringTokenizer((String)e.nextElement(), "~");
                try {
                    tokens.nextToken();
                    backupNo = Integer.parseInt(tokens.nextToken());
                    if (backupNo <= max) continue;
                    max = backupNo;
                }
                catch (NoSuchElementException ex1) {}
            }
        }
        catch (RegExprSyntaxException ex2) {
            // empty catch block
        }
        return max;
    }
}

