/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.common.environment;

import com.installshield.wizard.platform.common.environment.EnvironmentVariableManager;
import com.installshield.wizard.service.ServiceException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class EnvironmentVariableManagerGroup {
    private Vector managers = new Vector();

    public void add(EnvironmentVariableManager mgr) {
        this.managers.addElement(mgr);
    }

    public void remove(EnvironmentVariableManager mgr) {
        this.managers.removeElement(mgr);
    }

    public boolean variableExists(String variableName) {
        if (this.managers.size() > 0) {
            return ((EnvironmentVariableManager)this.managers.elementAt(0)).variableExists(variableName);
        }
        return false;
    }

    public void setVariable(String variableName, String variableValue) {
        Enumeration e = this.managers.elements();
        while (e.hasMoreElements()) {
            EnvironmentVariableManager mgr = (EnvironmentVariableManager)e.nextElement();
            if (mgr == null || !mgr.isInitialized()) continue;
            mgr.setVariable(variableName, variableValue);
        }
    }

    public String getVariable(String variableName) {
        if (this.managers.size() > 0) {
            return ((EnvironmentVariableManager)this.managers.elementAt(0)).getVariable(variableName);
        }
        return null;
    }

    public void deleteVariable(String variableName) {
        Enumeration e = this.managers.elements();
        while (e.hasMoreElements()) {
            EnvironmentVariableManager mgr = (EnvironmentVariableManager)e.nextElement();
            if (mgr == null || !mgr.isInitialized()) continue;
            mgr.deleteVariable(variableName);
        }
    }

    public void appendVariable(String variableName, String variableValue, String delimiter) {
        Enumeration e = this.managers.elements();
        while (e.hasMoreElements()) {
            EnvironmentVariableManager mgr = (EnvironmentVariableManager)e.nextElement();
            if (mgr == null || !mgr.isInitialized()) continue;
            mgr.appendVariable(variableName, variableValue, delimiter);
        }
    }

    public void unAppendVariable(String variableName, String variableValue, String delimiter) {
        Enumeration e = this.managers.elements();
        while (e.hasMoreElements()) {
            EnvironmentVariableManager mgr = (EnvironmentVariableManager)e.nextElement();
            if (mgr == null || !mgr.isInitialized()) continue;
            mgr.unAppendVariable(variableName, variableValue, delimiter);
        }
    }

    public void prependVariable(String variableName, String variableValue, String delimiter) {
        Enumeration e = this.managers.elements();
        while (e.hasMoreElements()) {
            EnvironmentVariableManager mgr = (EnvironmentVariableManager)e.nextElement();
            if (mgr == null || !mgr.isInitialized()) continue;
            mgr.prependVariable(variableName, variableValue, delimiter);
        }
    }

    public void unPrependVariable(String variableName, String variableValue, String delimiter) {
        Enumeration e = this.managers.elements();
        while (e.hasMoreElements()) {
            EnvironmentVariableManager mgr = (EnvironmentVariableManager)e.nextElement();
            if (mgr == null || !mgr.isInitialized()) continue;
            mgr.unPrependVariable(variableName, variableValue, delimiter);
        }
    }

    public void makeUpdatePersistent() throws ServiceException {
        boolean error = false;
        StringBuffer buf = new StringBuffer();
        Enumeration e = this.managers.elements();
        while (e.hasMoreElements()) {
            EnvironmentVariableManager mgr = (EnvironmentVariableManager)e.nextElement();
            if (mgr == null || !mgr.isInitialized()) continue;
            try {
                mgr.makeUpdatePersistent();
            }
            catch (IOException ioErr) {
                error = true;
                if (buf.length() != 0) {
                    buf.append(System.getProperty("line.separator"));
                }
                buf.append(ioErr.getMessage());
            }
        }
        if (error) {
            throw new ServiceException(new IOException(buf.toString()));
        }
    }
}

