/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.common.environment;

import com.installshield.wizard.platform.common.environment.EnvironmentVariableManager;
import java.io.IOException;

public abstract class GenericEnvironmentVariableManager
implements EnvironmentVariableManager {
    private boolean initialized = false;

    protected abstract void initializeImpl() throws IOException;

    protected abstract String getEchoCommandString(String var1);

    public final void initialize() throws IOException {
        this.initializeImpl();
        this.initialized = true;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public void appendVariable(String variableName, String variableValue, String delimiter) {
        if (this.variableExists(variableName)) {
            this.setVariable(variableName, this.getVariable(variableName) + this.makeDelimiter(delimiter) + variableValue);
        } else {
            String echoPart = this.getEchoCommandString(variableName);
            if (echoPart != null && echoPart.length() > 0) {
                echoPart = echoPart + this.makeDelimiter(delimiter);
            }
            this.setVariable(variableName, echoPart + variableValue);
        }
    }

    public void unAppendVariable(String variableName, String variableValue, String delimiter) {
        if (!this.variableExists(variableName)) {
            return;
        }
        String currValue = this.getVariable(variableName);
        String echo = this.getEchoCommandString(variableName);
        int startIndex = echo == null || echo.length() == 0 ? 0 : currValue.indexOf(echo);
        if (startIndex >= 0) {
            String newValue = this.removeAppendedEnvVar(currValue, variableValue, delimiter, startIndex += this.getEchoCommandString(variableName).length());
            if (newValue == null || newValue.length() == 0) {
                this.deleteVariable(variableName);
            } else {
                this.setVariable(variableName, newValue);
            }
        }
    }

    public void prependVariable(String variableName, String variableValue, String delimiter) {
        if (this.variableExists(variableName)) {
            this.setVariable(variableName, variableValue + this.makeDelimiter(delimiter) + this.getVariable(variableName));
        } else {
            String echoPart = this.getEchoCommandString(variableName);
            if (echoPart != null && echoPart.length() > 0) {
                echoPart = this.makeDelimiter(delimiter) + echoPart;
            }
            this.setVariable(variableName, variableValue + echoPart);
        }
    }

    public void unPrependVariable(String variableName, String variableValue, String delimiter) {
        if (!this.variableExists(variableName)) {
            return;
        }
        String currValue = this.getVariable(variableName);
        String echo = this.getEchoCommandString(variableName);
        int stopIndex = echo == null || echo.length() == 0 ? currValue.length() : currValue.indexOf(echo);
        if (stopIndex >= 0) {
            String newValue = this.removePrependedEnvVar(currValue, variableValue, delimiter, stopIndex += this.getEchoCommandString(variableName).length());
            if (newValue == null || newValue.length() == 0) {
                this.deleteVariable(variableName);
            } else {
                this.setVariable(variableName, newValue);
            }
        }
    }

    private String makeDelimiter(String delimiter) {
        return delimiter == null ? "" : delimiter;
    }

    private String removeAppendedEnvVar(String currValue, String removeValue, String delimiter, int startIndex) {
        String newValue = "";
        int index = -1;
        int length = 0;
        if (delimiter == null || delimiter.length() <= 0) {
            index = currValue.indexOf(removeValue, startIndex);
            length = removeValue.length();
        } else {
            index = currValue.indexOf(delimiter + removeValue, startIndex);
            if (index >= 0) {
                length = removeValue.length() + delimiter.length();
            } else {
                index = currValue.indexOf(removeValue, startIndex);
                if (index >= 0) {
                    length = removeValue.length();
                }
            }
        }
        if (index >= 0 && index >= startIndex) {
            newValue = currValue.substring(0, index);
            newValue = newValue + currValue.substring(index + length);
        } else {
            newValue = currValue;
        }
        return newValue;
    }

    private String removePrependedEnvVar(String currValue, String removeValue, String delimiter, int stopIndex) {
        String newValue = "";
        int index = -1;
        int length = 0;
        if (delimiter == null || delimiter.length() <= 0) {
            index = currValue.indexOf(removeValue);
            length = removeValue.length();
        } else {
            index = currValue.indexOf(removeValue + delimiter);
            if (index >= 0) {
                length = removeValue.length() + delimiter.length();
            } else {
                index = currValue.indexOf(removeValue);
                if (index >= 0) {
                    length = removeValue.length();
                }
            }
        }
        if (index >= 0 && index + length <= stopIndex) {
            newValue = currValue.substring(0, index);
            newValue = newValue + currValue.substring(index + length);
        } else {
            newValue = currValue;
        }
        return newValue;
    }

    public abstract /* synthetic */ String getCommentString();

    public abstract /* synthetic */ void makeUpdatePersistent() throws IOException;

    public abstract /* synthetic */ void deleteVariable(String var1);

    public abstract /* synthetic */ String getVariable(String var1);

    public abstract /* synthetic */ void setVariable(String var1, String var2);

    public abstract /* synthetic */ boolean variableExists(String var1);
}

