/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.common.environment;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.FileUtils;
import com.installshield.wizard.platform.common.environment.GenericEnvironmentVariableManager;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.CRC32;

public abstract class ScriptEnvironmentVariableManager
extends GenericEnvironmentVariableManager {
    public static final String lineSeparator = System.getProperty("line.separator");
    public static final String spaceSeparator = new String(new byte[]{32});
    private static final String header = " Begin INSTALLSHIELD Environment Variable Section";
    private static final String footer = " End INSTALLSHIELD Environment Variable Section";
    private static final String doNotEdit = " Do not edit this section manually.";
    private String scriptFile = null;
    private OrderedHashtable sectionBuffer = new OrderedHashtable();
    private Hashtable delimiters = new Hashtable();
    private byte[] fileBuffer = new byte[0];

    public ScriptEnvironmentVariableManager(String scriptFile) {
        this.scriptFile = scriptFile;
    }

    protected void initializeImpl() throws IOException {
        this.loadFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFile() throws IOException {
        block11: {
            RandomAccessFile ras = null;
            try {
                int size;
                if (System.getProperty("is.debug") != null) {
                    System.out.println("loading " + this.scriptFile + " for environmental variable update");
                }
                if ((size = (int)(ras = new RandomAccessFile(this.scriptFile, "r")).length()) == 0) {
                    return;
                }
                this.fileBuffer = new byte[size];
                int read = 0;
                for (int totalRead = 0; totalRead <= size && (read = ras.read(this.fileBuffer)) != -1; totalRead += read) {
                }
                String fileBytes = new String(this.fileBuffer);
                int index = fileBytes.indexOf(header);
                if (index < 0) break block11;
                ras.seek(index);
                ras.readLine();
                String line = ras.readLine().trim();
                while (line != null && !line.equals(this.getCommentString() + footer)) {
                    try {
                        this.loadVariable(line);
                    }
                    catch (NoSuchElementException e) {
                        // empty catch block
                    }
                    line = ras.readLine().trim();
                }
            }
            finally {
                if (ras != null) {
                    ras.close();
                }
            }
        }
    }

    public boolean variableExists(String variableName) {
        return this.sectionBuffer.containsKey(variableName);
    }

    public void setVariable(String variableName, String variableValue) {
        this.sectionBuffer.put(variableName, variableValue);
    }

    public void appendVariable(String variableName, String variableValue, String delimiter) {
        super.appendVariable(variableName, variableValue, delimiter);
        this.setDelimiterForVariable(variableName, delimiter);
    }

    public void unAppendVariable(String variableName, String variableValue, String delimiter) {
        super.unAppendVariable(variableName, variableValue, delimiter);
        this.setDelimiterForVariable(variableName, delimiter);
    }

    public void prependVariable(String variableName, String variableValue, String delimiter) {
        super.prependVariable(variableName, variableValue, delimiter);
        this.setDelimiterForVariable(variableName, delimiter);
    }

    public void unPrependVariable(String variableName, String variableValue, String delimiter) {
        super.unPrependVariable(variableName, variableValue, delimiter);
        this.setDelimiterForVariable(variableName, delimiter);
    }

    private void setDelimiterForVariable(String variableName, String delimiter) {
        if (delimiter == null || delimiter.length() <= 0) {
            this.delimiters.remove(variableName);
        } else {
            this.delimiters.put(variableName, delimiter);
        }
    }

    public String getVariable(String variableName) {
        return (String)this.sectionBuffer.get(variableName);
    }

    public void deleteVariable(String variableName) {
        if (this.sectionBuffer.containsKey(variableName)) {
            this.sectionBuffer.remove(variableName);
        }
    }

    public void makeUpdatePersistent() throws IOException {
        String fileBytes = new String(this.fileBuffer);
        int index = fileBytes.indexOf(this.getCommentString() + header);
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        if (index >= 0) {
            boas.write(this.fileBuffer, 0, index);
        } else {
            String s = new String(this.fileBuffer, 0, this.fileBuffer.length);
            if (!s.endsWith(lineSeparator)) {
                s = s + lineSeparator;
            }
            boas.write(s.getBytes());
        }
        this.removeUnmodifiers();
        if (this.sectionBuffer.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getCommentString()).append(header).append(lineSeparator);
            boas.write(buffer.toString().getBytes());
            buffer = new StringBuffer();
            buffer.append(this.getCommentString()).append(doNotEdit).append(lineSeparator);
            boas.write(buffer.toString().getBytes());
            boas.write(this.writeAllVariables().getBytes());
            buffer = new StringBuffer();
            buffer.append(this.getCommentString()).append(footer).append(lineSeparator);
            boas.write(buffer.toString().getBytes());
        }
        if ((index = fileBytes.indexOf(this.getCommentString() + footer)) > 0) {
            int startFrom = index + this.getCommentString().length() + footer.length() + lineSeparator.length();
            boas.write(this.fileBuffer, startFrom, this.fileBuffer.length - startFrom);
        }
        CRC32 crc = new CRC32();
        crc.update(this.fileBuffer);
        long originalValue = crc.getValue();
        crc.reset();
        crc.update(boas.toByteArray());
        long modified = crc.getValue();
        if (originalValue != modified) {
            FileOutputStream fos = new FileOutputStream(this.getBackupFileName(CoreFileUtils.getParent(this.scriptFile), FileUtils.getName(this.scriptFile)));
            ByteArrayOutputStream backupStream = new ByteArrayOutputStream();
            backupStream.write(this.fileBuffer);
            backupStream.flush();
            backupStream.close();
            backupStream.writeTo(fos);
            fos.flush();
            fos.close();
            if (System.getProperty("is.debug") != null) {
                System.out.println("commiting environmental variable update to script file = " + this.scriptFile);
            }
            fos = new FileOutputStream(this.scriptFile);
            boas.flush();
            boas.close();
            boas.writeTo(fos);
            fos.flush();
            fos.close();
        }
    }

    protected abstract String getBackupFileName(String var1, String var2);

    private void loadVariable(String line) {
        if (line.startsWith(this.getCommentString() + spaceSeparator + "var")) {
            StringTokenizer tokens = new StringTokenizer(line);
            tokens.nextToken();
            tokens.nextToken();
            String hasDelimiter = tokens.nextToken();
            String delimiter = null;
            if (hasDelimiter.equals("1")) {
                delimiter = tokens.nextToken();
            }
            String variableName = tokens.nextToken("=").trim();
            this.setDelimiterForVariable(variableName, delimiter);
            if (tokens.hasMoreTokens()) {
                this.getSectionBuffer().put(variableName, tokens.nextToken().trim());
            } else {
                this.getSectionBuffer().put(variableName, new String(""));
            }
        }
    }

    private void removeUnmodifiers() {
        Enumeration e = this.sectionBuffer.keys();
        Vector<String> variables = new Vector<String>();
        while (e.hasMoreElements()) {
            String variableName = (String)e.nextElement();
            String variableValue = (String)this.sectionBuffer.get(variableName);
            if (!this.getEchoCommandString(variableName).equals(variableValue)) continue;
            variables.add(variableName);
        }
        for (int i = 0; i < variables.size(); ++i) {
            this.sectionBuffer.remove((String)variables.get(i));
        }
    }

    protected final OrderedHashtable getSectionBuffer() {
        return this.sectionBuffer;
    }

    protected String writeAllVariables() {
        StringBuffer output = new StringBuffer();
        Enumeration e = this.sectionBuffer.keys();
        while (e.hasMoreElements()) {
            String variableName = (String)e.nextElement();
            String variableValue = (String)this.sectionBuffer.get(variableName);
            if (variableName == null || variableValue == null) continue;
            output.append(this.getCommentString());
            output.append(" var ");
            String delimiter = (String)this.delimiters.get(variableName);
            output.append(delimiter == null || delimiter.length() == 0 ? "0 " : "1 ");
            if (delimiter != null && delimiter.length() > 0) {
                output.append(delimiter + " ");
            }
            output.append(variableName);
            output.append("=");
            output.append(variableValue);
            output.append(lineSeparator);
            output.append(this.writeVariable(variableName, variableValue, this.getValueWithoutEcho(variableName, variableValue)));
            output.append(lineSeparator);
        }
        return output.toString();
    }

    private String getValueWithoutEcho(String variableName, String valueWithEcho) {
        String echo = this.getEchoCommandString(variableName);
        if (echo == null || echo.length() == 0) {
            return valueWithEcho;
        }
        String strValue = valueWithEcho;
        String delimiter = (String)this.delimiters.get(variableName);
        int echoLen = echo.length();
        int index = -1;
        int length = 0;
        if (delimiter == null || delimiter.length() == 0) {
            index = valueWithEcho.indexOf(echo);
            if (index >= 0) {
                length = echoLen;
            }
        } else {
            int delimiterLen = delimiter.length();
            index = valueWithEcho.indexOf(delimiter + echo);
            if (index >= 0) {
                length = delimiterLen + echoLen;
            } else {
                index = valueWithEcho.indexOf(echo + delimiter);
                if (index >= 0) {
                    length = echoLen + delimiterLen;
                }
            }
        }
        if (index >= 0) {
            strValue = valueWithEcho.substring(0, index);
            strValue = strValue + valueWithEcho.substring(index + length);
        }
        return strValue;
    }

    protected abstract String writeVariable(String var1, String var2, String var3);

    class OrderedHashtable
    extends Hashtable {
        private Vector keys = new Vector();

        public OrderedHashtable() {
        }

        public OrderedHashtable(int capacity) {
            super(capacity);
        }

        public OrderedHashtable(int capacity, float loadFactor) {
            super(capacity, loadFactor);
        }

        public synchronized Object getKeyAt(int position) {
            return this.keys.elementAt(position);
        }

        public synchronized Enumeration keys() {
            return this.keys.elements();
        }

        public synchronized Enumeration elements() {
            Vector data = new Vector();
            for (int i = 0; i < this.keys.size(); ++i) {
                data.addElement(this.get(this.keys.elementAt(i)));
            }
            return data.elements();
        }

        public synchronized Object put(Object key, Object value) {
            Object result = super.put(key, value);
            if (result == null) {
                this.keys.addElement(key);
            }
            return result;
        }

        public synchronized Object remove(Object key) {
            this.keys.removeElement(key);
            return super.remove(key);
        }

        public synchronized void clear() {
            this.keys.removeAllElements();
            super.clear();
        }
    }
}

