/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.common.util;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.CommandResult;
import com.installshield.util.CommandUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.security.GroupSpecification;
import com.installshield.wizard.service.security.UserSpecification;
import java.text.SimpleDateFormat;
import java.util.Date;

public class GenericUnixCommands {
    private static final String BOURNE_SHELL_CMD = "sh";
    private static final String READ_FROM_STRING = "-c";

    public static void createSymbolicLink(String target, String linkName, boolean forceLink) throws ServiceException {
        target = GenericUnixCommands.containsSpaceChar(target) ? '\"' + target + '\"' : target;
        linkName = GenericUnixCommands.containsSpaceChar(linkName) ? '\"' + linkName + '\"' : linkName;
        String command = forceLink ? "ln -s -f " + target + " " + linkName : "ln -s " + target + " " + linkName;
        GenericUnixCommands.executeBourneShellCommand(command);
    }

    public static void removeSymbolicLink(String linkName) throws ServiceException {
        linkName = GenericUnixCommands.containsSpaceChar(linkName) ? '\"' + linkName + '\"' : linkName;
        String command = "rm " + linkName;
        GenericUnixCommands.executeBourneShellCommand(command);
    }

    public static String getMountPoints() throws ServiceException {
        return GenericUnixCommands.executeBourneShellCommand("mount");
    }

    public static void deleteGroup(String groupName) throws ServiceException {
        if (groupName != null) {
            String command = "/usr/sbin/groupdel \"" + groupName + '\"';
            GenericUnixCommands.executeBourneShellCommand(command);
        }
    }

    public static void createGroup(GroupSpecification groupSpec) throws ServiceException {
        if (groupSpec != null) {
            GenericUnixCommands.executeBourneShellCommand("/usr/sbin/groupadd \"" + groupSpec.getGroupName() + '\"');
            UserSpecification[] users = groupSpec.getUsers();
            if (users != null) {
                for (int i = 0; i < users.length; ++i) {
                    GenericUnixCommands.executeBourneShellCommand("/usr/sbin/usermod -G " + groupSpec.getGroupName() + " " + users[i].getUserName());
                }
            }
        }
    }

    public static void createUser(UserSpecification userSpec) throws ServiceException {
        if (userSpec != null) {
            GroupSpecification[] groups;
            StringBuffer commandBuf = new StringBuffer();
            commandBuf.append("/usr/sbin/useradd ");
            if (userSpec.getUserFullName() != null) {
                commandBuf.append("-c \"" + userSpec.getUserFullName() + '\"' + " ");
            }
            if (userSpec.getHomeDirectory() != null) {
                commandBuf.append("-d \"" + userSpec.getHomeDirectory() + '\"' + " -m ");
            }
            if (userSpec.getAccountExpirationDate() > 0L) {
                commandBuf.append("-e ");
                commandBuf.append(new SimpleDateFormat("MM/dd/yy").format(new Date(userSpec.getAccountExpirationDate())));
                commandBuf.append(" ");
            }
            if ((groups = userSpec.getGroups()) != null && groups.length > 0) {
                commandBuf.append("-G ");
                for (int i = 0; i < groups.length; ++i) {
                    if (i > 0) {
                        commandBuf.append(",");
                    }
                    commandBuf.append(groups[i].getGroupName());
                }
                commandBuf.append(" ");
            }
            if (userSpec.getPrimaryGroup() != null) {
                commandBuf.append("-g " + userSpec.getPrimaryGroup());
                commandBuf.append(" ");
            }
            commandBuf.append('\"' + userSpec.getUserName() + '\"');
            GenericUnixCommands.executeBourneShellCommand(commandBuf.toString());
        }
    }

    public static void deleteUser(String user) throws ServiceException {
        GenericUnixCommands.executeBourneShellCommand("/usr/sbin/userdel -r " + user);
    }

    public static String locateExecutable(String exeName) throws ServiceException {
        String ret = GenericUnixCommands.executeBourneShellCommand("/usr/bin/which \"" + exeName + "\"");
        if (ret.indexOf(CoreFileUtils.systemLF) != -1) {
            ret = ret.substring(0, ret.lastIndexOf(CoreFileUtils.systemLF));
        }
        return ret;
    }

    private static String executeBourneShellCommand(String commandStr) throws ServiceException {
        CommandResult result;
        String[] commandArray = new String[]{READ_FROM_STRING, commandStr};
        try {
            result = CommandUtils.executeCommand(BOURNE_SHELL_CMD, commandArray);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        if (result.getExitCode() != 0) {
            throw new ServiceException(315, result.getStderr());
        }
        return result.getStdout();
    }

    private static boolean containsSpaceChar(String str) {
        return str.indexOf(32) != -1;
    }

    public static String formatFileName(String filePath) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filePath.length(); ++i) {
            if (filePath.charAt(i) == ' ') {
                sb.append('\\');
            }
            sb.append(filePath.charAt(i));
        }
        return sb.toString();
    }
}

