/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.common.util;

import com.installshield.wizard.platform.common.util.NativeObject;
import com.installshield.wizard.service.ServiceException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;

public class NativeObjectImpl
implements NativeObject {
    private String exeName;
    private Process process;
    private PrintWriter out;
    private Hashtable retryHashtable = new Hashtable();
    private BufferedReader stdoutStream;
    private BufferedReader stderrStream;
    private static final String ERROR = "ERROR";
    private static final String magicNumber = "829498192872947";
    private static final String[] supportedVersions = new String[]{"1"};
    StringBuffer buffer = new StringBuffer();

    public NativeObjectImpl(String exeFileName) throws IOException, ServiceException {
        this.exeName = exeFileName;
        this.init();
    }

    public void init() throws IOException, ServiceException {
        this.process = Runtime.getRuntime().exec(this.exeName);
        this.out = new PrintWriter(this.process.getOutputStream());
        this.stdoutStream = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        this.stderrStream = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        String magicNumber = this.stdoutStream.readLine();
        if (magicNumber.equals(magicNumber)) {
            String version = this.stdoutStream.readLine();
            boolean versionIsSupported = false;
            for (int i = 0; i < supportedVersions.length; ++i) {
                if (!supportedVersions[i].equals(version)) continue;
                versionIsSupported = true;
                break;
            }
            if (!versionIsSupported) {
                throw new ServiceException(1);
            }
        } else {
            throw new ServiceException(1);
        }
    }

    public synchronized Object invokeMethod(String methodName, Class[] parameterTypes, Object[] parameterValues) throws ServiceException {
        return this.invokeMethod(methodName, parameterTypes, parameterValues, 0);
    }

    public synchronized Object invokeMethod(String methodName, Class[] parameterTypes, Object[] parameterValues, int timeout) throws ServiceException {
        if (this.process == null) {
            throw new IllegalStateException("native executable is destroyed");
        }
        if (parameterTypes.length != parameterValues.length) {
            throw new ServiceException(2, "parameterTypes and parameterValues must have the same number of elements");
        }
        if (!(parameterValues instanceof String[])) {
            throw new ServiceException(2, "parameterValues must be array of Strings");
        }
        return this.invokeMethod(methodName, (String[])parameterValues, timeout);
    }

    public synchronized String invokeMethod(String methodName, String[] parameterValues) throws ServiceException {
        return this.invokeMethod(methodName, parameterValues, 0);
    }

    public synchronized String invokeMethod(String methodName, String[] parameterValues, int timeout) throws ServiceException {
        if (this.process == null) {
            throw new IllegalStateException("native executable is destroyed");
        }
        try {
            this.buffer.delete(0, this.buffer.length());
            this.buffer.append(methodName).append(' ');
            for (int i = 0; i < parameterValues.length; ++i) {
                this.buffer.append('\"').append(parameterValues[i]).append('\"').append(' ');
            }
            this.buffer.append('\n');
            StringBuffer filteredBuffer = new StringBuffer();
            for (int i = 0; i < this.buffer.length(); ++i) {
                if (this.buffer.charAt(i) == '$') {
                    filteredBuffer.append("\\\\").append('$');
                    continue;
                }
                filteredBuffer.append(this.buffer.charAt(i));
            }
            this.buffer = filteredBuffer;
            if (System.getProperty("is.debug") != null) {
                System.out.println("invoking the function " + methodName + " with parameters " + this.buffer.toString());
            }
            String bufferStr = this.buffer.toString();
            this.out.write(bufferStr);
            this.out.flush();
            String so = this.stdoutStream.readLine();
            if (so != null && !so.equals(ERROR)) {
                return so;
            }
            if (this.retryHashtable.get(bufferStr) == null) {
                this.retryHashtable.put(bufferStr, "dummy");
                this.finalize();
                this.init();
                return this.invokeMethod(methodName, parameterValues, 0);
            }
            ServiceException se = new ServiceException(2);
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        if (this.process == null) {
            return;
        }
        try {
            PrintWriter out = new PrintWriter(this.process.getOutputStream());
            out.write("stop\n");
            out.flush();
            this.process.waitFor();
        }
        catch (Exception e) {
            this.process.destroy();
        }
        finally {
            this.process = null;
        }
    }

    protected void finalize() {
        this.destroy();
        this.process = null;
    }

    public boolean isAlive() {
        if (this.process == null) {
            return false;
        }
        try {
            this.process.exitValue();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void main(String[] args) {
        try {
            if (args[0] != null) {
                NativeObjectImpl no = new NativeObjectImpl(args[0]);
                String s = null;
                for (int i = 0; i < 5; ++i) {
                    s = no.invokeMethod("getFileOwner", new String[]{"/etc/passwd"});
                    System.out.println("got =" + s);
                }
                no.invokeMethod("setFileOwner", new String[]{"/home/shak/mar2004/log.txt", "shak"});
                no.destroy();
            } else {
                System.err.println("shell script path is missing");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

