/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.genericunix.service.file;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.CommandUtils;
import com.installshield.util.FileAttributes;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.ProcessExecException;
import com.installshield.wizard.platform.common.util.GenericUnixCommands;
import com.installshield.wizard.platform.common.util.GenericUnixFileAttributes;
import com.installshield.wizard.platform.genericunix.GenericUnixPlatform;
import com.installshield.wizard.platform.genericunix.utils.GenericUnixShellInterface;
import com.installshield.wizard.platform.genericunix.utils.GenericUnixUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.file.PureJavaFileServiceImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class GenericUnixFileServiceImpl
extends PureJavaFileServiceImpl {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmm");

    public int getSystemCompatibility() {
        if (System.getProperty("is.debug") != null) {
            System.out.println("GenericUnixFileServiceImpl returns compatibility: " + GenericUnixPlatform.getSystemCompatibility());
        }
        return GenericUnixPlatform.getSystemCompatibility();
    }

    protected void initialized() {
        super.initialized();
        try {
            URL url = this.getServiceResource(GenericUnixUtils.getGenericUnixServiceResHome() + GenericUnixUtils.getGenericUnixShellScriptSupport());
            GenericUnixShellInterface.initialize(url);
        }
        catch (Exception ex) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.genericunix.i18n.GenericUnixResources", "genericunix.scriptInitializationFailure", new String[]{FileService.NAME, GenericUnixUtils.getGenericUnixShellScriptSupport()}));
            ex.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public int deleteDirectory(String directory, boolean ifEmpty, boolean includeSubDirs) throws ServiceException {
        returnValue = 0;
        error = false;
        errorMessage = "";
        dirName = this.createFileName(this.getCurrentDirectory(), directory);
        if (this.fileExists(dirName) && this.isDirectory(dirName) && this.getParent(dirName) == null) {
            throw new ServiceException(305, "deleteDirectory cannot be used to delete the root directory");
        }
        if (this.isDirectory(dirName)) {
            if (!ifEmpty && !includeSubDirs) {
                try {
                    dirCmdString = CoreFileUtils.appendSeparator(dirName, this.getSeparator()) + "*";
                    info = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -f \"" + dirCmdString + "\""});
                    if (info.getExitCode() == 0) {
                        info = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir \"" + dirName + "\""});
                        if (info.getExitCode() == 0) ** GOTO lbl42
                        error = true;
                        errorMessage = info.getStderr();
                    }
                    error = true;
                    errorMessage = info.getStderr();
                }
                catch (Exception genErr) {
                    throw new ServiceException(genErr);
                }
            } else if (ifEmpty && !includeSubDirs) {
                try {
                    info = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir \"" + dirName + "\""});
                    if (info.getExitCode() == 0) ** GOTO lbl42
                    error = true;
                    errorMessage = info.getStderr();
                }
                catch (Exception genErr) {
                    throw new ServiceException(genErr);
                }
            } else if (!ifEmpty && includeSubDirs) {
                try {
                    info = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -rf \"" + dirName + "\""});
                    if (info.getExitCode() == 0) ** GOTO lbl42
                    error = true;
                    errorMessage = info.getStderr();
                }
                catch (Exception genErr) {
                    throw new ServiceException(genErr);
                }
            } else {
                returnValue = super.deleteDirectory(directory, ifEmpty, includeSubDirs);
            }
        }
lbl42:
        // 10 sources

        if (error) {
            throw new ServiceException(2, "Error deleting directory: " + errorMessage);
        }
        return returnValue;
    }

    public void setFileTimes(String file, long creationDate, long accessDate, long writeDate) throws ServiceException {
        try {
            GenericUnixShellInterface.getNativeObject().invokeMethod("setFileTimes", new String[]{GenericUnixCommands.formatFileName(file), GenericUnixFileServiceImpl.convertDate(creationDate), GenericUnixFileServiceImpl.convertDate(accessDate), GenericUnixFileServiceImpl.convertDate(writeDate)});
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, FileService.NAME + ":Error invoking setFileTimes for " + file + " Got exception: " + e);
        }
    }

    public void setFileCreated(String fileName, long date) throws ServiceException {
    }

    public void setFileModified(String file, long date) throws ServiceException {
        try {
            GenericUnixShellInterface.getNativeObject().invokeMethod("setFileModified", new String[]{GenericUnixCommands.formatFileName(file), GenericUnixFileServiceImpl.convertDate(date)});
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, FileService.NAME + ":Error invoking setFileModified for " + file + " Got exception: " + e);
        }
    }

    protected String getLibraryDirectory() throws ServiceException {
        return "/usr/lib";
    }

    protected String getStandardInstallDirectory() throws ServiceException {
        return "/opt";
    }

    protected String getTempDirectory() throws ServiceException {
        return "/tmp";
    }

    public String[] getPartitionNames() throws ServiceException {
        try {
            File f = null;
            String partition = null;
            Vector<String> partitions = new Vector<String>();
            StringTokenizer tokens = new StringTokenizer(GenericUnixShellInterface.getNativeObject().invokeMethod("getPartitionNames", new String[0]), ",");
            while (tokens.hasMoreTokens()) {
                partition = tokens.nextToken();
                f = new File(partition);
                if (!f.exists() || !f.isDirectory()) continue;
                partitions.addElement(partition);
            }
            Object[] partitionNames = new String[partitions.size()];
            partitions.copyInto(partitionNames);
            return partitionNames;
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, FileService.NAME + ":Error invoking getPartitionNames - Got exception: " + e);
        }
    }

    public long getPartitionFreeSpace(String partitionName) throws ServiceException {
        try {
            return Long.parseLong(GenericUnixShellInterface.getNativeObject().invokeMethod("getPartitionFreeSpace", new String[]{partitionName}));
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, FileService.NAME + ":Error invoking getPartitionFreeSpace for partition" + partitionName + " Got exception: " + e);
        }
    }

    public FileAttributes getFileAttributes(String file) throws ServiceException {
        try {
            String attrib = GenericUnixShellInterface.getNativeObject().invokeMethod("getFileAttributes", new String[]{GenericUnixCommands.formatFileName(file)});
            return GenericUnixFileAttributes.getAttributeObject(Integer.parseInt(attrib));
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, FileService.NAME + ":Error invoking getFileAttributes for " + file + " Got exception: " + e);
        }
    }

    public void setFileAttributes(String file, FileAttributes attributes) throws ServiceException {
        try {
            GenericUnixShellInterface.getNativeObject().invokeMethod("setFileAttributes", new String[]{GenericUnixCommands.formatFileName(file), GenericUnixFileAttributes.getGUMode(attributes)});
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, FileService.NAME + ":Error invoking setFileAttributes for " + file + " Got exception: " + e);
        }
    }

    public void setFileExecutable(String file) throws ServiceException {
        try {
            FileAttributes attrib = this.getFileAttributes(file);
            attrib.setAttributeState(292, true);
            this.setFileAttributes(file, attrib);
        }
        catch (ServiceException e) {
            throw new ServiceException(2, FileService.NAME + ":Error invoking setFileExecutable for " + file + " Got exception: " + e);
        }
    }

    public String getFileOwner(String file) throws ServiceException {
        try {
            return GenericUnixShellInterface.getNativeObject().invokeMethod("getFileOwner", new String[]{GenericUnixCommands.formatFileName(file)});
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, FileService.NAME + ":Error invoking getFileOwner for " + file + " Got exception: " + e);
        }
    }

    public void setFileOwner(String file, String userid) throws ServiceException {
        try {
            GenericUnixShellInterface.getNativeObject().invokeMethod("setFileOwner", new String[]{GenericUnixCommands.formatFileName(file), userid});
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, FileService.NAME + ":Error invoking setFileOwner for " + file + " Got exception: " + e);
        }
    }

    public String getFileOwnerGroup(String file) throws ServiceException {
        try {
            return GenericUnixShellInterface.getNativeObject().invokeMethod("getFileOwnerGroup", new String[]{GenericUnixCommands.formatFileName(file)});
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, FileService.NAME + ":Error invoking getFileOwnerGroup for " + file + " Got exception: " + e);
        }
    }

    public void setFileOwnerGroup(String file, String groupid) throws ServiceException {
        try {
            GenericUnixShellInterface.getNativeObject().invokeMethod("setFileOwnerGroup", new String[]{GenericUnixCommands.formatFileName(file), groupid});
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, FileService.NAME + ":Error invoking setFileOwnerGroup for " + file + " Got exception: " + e);
        }
    }

    public boolean supportsLongFileNames(String partitionName) throws ServiceException {
        try {
            File f = new File(partitionName, "com.installshield.wizard.platform.genericunix.service.file.GenericUnixFileService");
            FileOutputStream fos = new FileOutputStream(f);
            fos.close();
            f.delete();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getPartitionType(String partition) throws ServiceException {
        return !(partition = partition.trim()).startsWith("/dev/") || !partition.substring(5).endsWith("cd") && !partition.substring(5).endsWith("fd") && !partition.substring(5).endsWith("rmt") ? 1 : 2;
    }

    public String getPartitionFormat(String partition) throws ServiceException {
        try {
            return GenericUnixShellInterface.getNativeObject().invokeMethod("getPartitionFormat", new String[]{partition});
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, FileService.NAME + ":Error invoking getPartitionFormat for " + partition + " Got exception: " + e);
        }
    }

    public void validateFileName(String fileName) throws ServiceException {
        String invalidChars = ":*?\"<>|^!";
        for (int i = 0; i < fileName.length(); ++i) {
            if (invalidChars.indexOf(fileName.charAt(i)) == -1) continue;
            throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "FileServiceImpl.invalidCharacters", new String[]{invalidChars}));
        }
    }

    public void setSystemUMask(int mode) throws ServiceException {
        throw new ServiceException(305, FileService.NAME + "Setting umask is not supported by GenericUnixFileService");
    }

    public int getSystemUMask() throws ServiceException {
        try {
            return Integer.parseInt(GenericUnixShellInterface.getNativeObject().invokeMethod("getSystemUMask", new String[0]));
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, FileService.NAME + ":Error invoking getSystemUMask" + " Got exception: " + e);
        }
    }

    private static String convertDate(long time) {
        return sdf.format(new Date(time));
    }

    public void createSymbolicLink(String target, String linkName, boolean forceLink) throws ServiceException {
        GenericUnixCommands.createSymbolicLink(target, linkName, forceLink);
    }

    public void removeSymbolicLink(String linkName) throws ServiceException {
        GenericUnixCommands.removeSymbolicLink(linkName);
    }

    public void cleanup() throws ServiceException {
        GenericUnixShellInterface.shutDown();
    }
}

