/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.genericunix.service.security;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.ProcessExecException;
import com.installshield.wizard.platform.genericunix.GenericUnixPlatform;
import com.installshield.wizard.platform.genericunix.utils.GenericUnixShellInterface;
import com.installshield.wizard.platform.genericunix.utils.GenericUnixUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.security.GroupSpecification;
import com.installshield.wizard.service.security.PureJavaSecurityServiceImpl;
import com.installshield.wizard.service.security.SecurityService;
import com.installshield.wizard.service.security.UserSpecification;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;

public class GenericUnixSecurityServiceImpl
extends PureJavaSecurityServiceImpl {
    private static String EMPTY_OPTION_PLACEHOLDER = "IS_NULL";

    public int getSystemCompatibility() {
        return GenericUnixPlatform.getSystemCompatibility();
    }

    protected void initialized() {
        super.initialized();
        try {
            URL url = this.getServiceResource(GenericUnixUtils.getGenericUnixServiceResHome() + GenericUnixUtils.getGenericUnixShellScriptSupport());
            GenericUnixShellInterface.initialize(url);
        }
        catch (Exception ex) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.genericunix.i18n.GenericUnixResources", "genericunix.scriptInitializationFailure", new String[]{SecurityService.NAME, GenericUnixUtils.getGenericUnixShellScriptSupport()}));
            ex.printStackTrace();
        }
    }

    public boolean isCurrentUserAdmin() throws ServiceException {
        try {
            return Boolean.valueOf(GenericUnixShellInterface.getNativeObject().invokeMethod("isCurrentUserAdmin", new String[0]));
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, SecurityService.NAME + ":Error invoking isCurrentUserAdmin" + " Got exception: " + e);
        }
    }

    public void createUser(UserSpecification userSpec) throws ServiceException {
        StringBuffer commandOptions = new StringBuffer();
        if (userSpec.getUserFullName() != null) {
            commandOptions.append(userSpec.getUserFullName());
        } else {
            commandOptions.append(EMPTY_OPTION_PLACEHOLDER);
        }
        commandOptions.append('+');
        if (userSpec.getGroups() != null && userSpec.getGroups().length > 0) {
            GroupSpecification[] g = userSpec.getGroups();
            StringBuffer groups = new StringBuffer();
            for (int i = 0; i < g.length; ++i) {
                if (i > 0) {
                    groups.append(',');
                }
                groups.append(g[i].getGroupName());
            }
            commandOptions.append(groups);
        } else {
            commandOptions.append(EMPTY_OPTION_PLACEHOLDER);
        }
        commandOptions.append('+');
        if (userSpec.getHomeDirectory() != null) {
            commandOptions.append(userSpec.getHomeDirectory());
        } else {
            commandOptions.append(EMPTY_OPTION_PLACEHOLDER);
        }
        commandOptions.append('+');
        if (userSpec.getAccountExpirationDate() > 0L) {
            commandOptions.append(new SimpleDateFormat("yyyy/MM/dd/hh/m").format(new Date(userSpec.getAccountExpirationDate())));
        } else {
            commandOptions.append(EMPTY_OPTION_PLACEHOLDER);
        }
        commandOptions.append('+');
        commandOptions.append(userSpec.getUserName());
        try {
            GenericUnixShellInterface.getNativeObject().invokeMethod("createUser", new String[]{commandOptions.toString()});
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, SecurityService.NAME + ":Error invoking createUser" + " for user " + userSpec.getUserName() + " Got exception: " + e);
        }
    }

    public void deleteUser(String userid) throws ServiceException {
        try {
            GenericUnixShellInterface.getNativeObject().invokeMethod("deleteUser", new String[]{userid});
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, SecurityService.NAME + ":Error invoking deleteUser" + " for user " + userid + " Got exception: " + e);
        }
    }

    public void createGroup(GroupSpecification groupSpec) throws ServiceException {
        try {
            GenericUnixShellInterface.getNativeObject().invokeMethod("createGroup", new String[]{groupSpec.getGroupName()});
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, SecurityService.NAME + ":Error invoking createGroup" + " for group " + groupSpec.getGroupName() + " Got exception: " + e);
        }
    }

    public void deleteGroup(String groupid) throws ServiceException {
        try {
            GenericUnixShellInterface.getNativeObject().invokeMethod("deleteGroup", new String[]{groupid});
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, SecurityService.NAME + ":Error invoking deleteGroup" + " for group " + groupid + " Got exception: " + e);
        }
    }

    public void cleanup() throws ServiceException {
        GenericUnixShellInterface.shutDown();
    }
}

