/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.genericunix.service.system;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.ProcessExecException;
import com.installshield.wizard.platform.common.environment.BourneShellManager;
import com.installshield.wizard.platform.common.environment.CShellManager;
import com.installshield.wizard.platform.common.environment.EnvironmentVariableManagerGroup;
import com.installshield.wizard.platform.common.environment.ScriptEnvironmentVariableManager;
import com.installshield.wizard.platform.genericunix.GenericUnixPlatform;
import com.installshield.wizard.platform.genericunix.utils.GenericUnixShellInterface;
import com.installshield.wizard.platform.genericunix.utils.GenericUnixUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.PureJavaSystemUtilServiceImpl;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;

public class GenericUnixSystemUtilServiceImpl
extends PureJavaSystemUtilServiceImpl {
    private static final String systemCshScript = "/etc/csh.login";
    private static final String userCshScript = ".login";
    private static final String systemBourneScript = "/etc/profile";
    private static final String userBourneScript = ".profile";
    private static EnvironmentVariableManagerGroup userEnvVarGroup;
    private static EnvironmentVariableManagerGroup systemEnvVarGroup;
    private static boolean envVarsCleanedUp;

    public int getSystemCompatibility() {
        return GenericUnixPlatform.getSystemCompatibility();
    }

    protected void initialized() {
        super.initialized();
        try {
            URL resource = this.getServiceResource(GenericUnixUtils.getGenericUnixServiceResHome() + GenericUnixUtils.getGenericUnixShellScriptSupport());
            GenericUnixShellInterface.initialize(resource);
            resource = this.getServiceResource(GenericUnixUtils.getGenericUnixServiceResHome() + GenericUnixUtils.getGenericUnixLockedFileSupport());
            GenericUnixUtils.initializeLockedFilesHandlerSupport(resource, GenericUnixUtils.getGenericUnixLockedFileSupport());
            FileUtils.setLockedFilesHandler(this);
        }
        catch (Exception ex) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.genericunix.i18n.GenericUnixResources", "genericunix.scriptInitializationFailure", new String[]{SystemUtilService.NAME, GenericUnixUtils.getGenericUnixShellScriptSupport()}));
            ex.printStackTrace();
        }
    }

    public String getEnvironmentVariable(String variableName) throws ServiceException {
        try {
            return GenericUnixShellInterface.getNativeObject().invokeMethod("getEnvironmentVariable", new String[]{variableName});
        }
        catch (ProcessExecException e) {
            throw new ServiceException(2, SystemUtilService.NAME + ":Error invoking getEnvironmentVariable for " + variableName + " Got exception: " + e);
        }
    }

    public String getRawEnvironmentVariable(String variableName, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            return group.getVariable(variableName);
        }
        return null;
    }

    public void setEnvironmentVariable(String key, String value) throws ServiceException {
        this.setEnvironmentVariable(key, value, 2);
    }

    public void setEnvironmentVariable(String variableName, String variableValue, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.setVariable(variableName, variableValue);
            this.setLogoutRequired(true);
        }
    }

    public void deleteEnvironmentVariable(String key) throws ServiceException {
        this.deleteEnvironmentVariable(key, 2);
    }

    public void deleteEnvironmentVariable(String variableName, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.deleteVariable(variableName);
            this.setLogoutRequired(true);
        }
    }

    public void appendEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.appendVariable(variableName, variableValue, delimiter);
            this.setLogoutRequired(true);
        }
    }

    public void unAppendEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.unAppendVariable(variableName, variableValue, delimiter);
            this.setLogoutRequired(true);
        }
    }

    public void prependEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.prependVariable(variableName, variableValue, delimiter);
            this.setLogoutRequired(true);
        }
    }

    public void unPrependEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.unPrependVariable(variableName, variableValue, delimiter);
            this.setLogoutRequired(true);
        }
    }

    private void verifyVariableName(String variableName) throws ServiceException {
        if (variableName == null || variableName.length() == 0) {
            throw new ServiceException(399, LocalizedStringResolver.resolve("com.installshield.wizard.platform.genericunix.i18n.GenericUnixResources", "systemUtil.variableNameRequired"));
        }
    }

    public void cleanup() throws ServiceException {
        if (!envVarsCleanedUp) {
            if (userEnvVarGroup != null) {
                userEnvVarGroup.makeUpdatePersistent();
            }
            if (systemEnvVarGroup != null) {
                systemEnvVarGroup.makeUpdatePersistent();
            }
            envVarsCleanedUp = true;
        }
        GenericUnixShellInterface.shutDown();
    }

    private EnvironmentVariableManagerGroup getEnvVarGroup(int level) throws ServiceException {
        EnvironmentVariableManagerGroup group = null;
        ScriptEnvironmentVariableManager manager = null;
        try {
            if (level == 1 && System.getProperty("user.name").equals("root")) {
                if (systemEnvVarGroup == null) {
                    systemEnvVarGroup = new EnvironmentVariableManagerGroup();
                    if (this.checkScriptFile(systemBourneScript)) {
                        manager = new BourneShellManager(systemBourneScript);
                        manager.initialize();
                        systemEnvVarGroup.add(manager);
                    }
                    if (this.checkScriptFile(systemCshScript)) {
                        manager = new CShellManager(systemCshScript);
                        manager.initialize();
                        systemEnvVarGroup.add(manager);
                    }
                }
                group = systemEnvVarGroup;
            } else if (level == 2) {
                if (userEnvVarGroup == null) {
                    userEnvVarGroup = new EnvironmentVariableManagerGroup();
                    String scriptFile = CoreFileUtils.createFileName(System.getProperty("user.home"), userBourneScript);
                    if (this.checkScriptFile(scriptFile)) {
                        manager = new BourneShellManager(scriptFile);
                        manager.initialize();
                        userEnvVarGroup.add(manager);
                    }
                    if (this.checkScriptFile(scriptFile = CoreFileUtils.createFileName(System.getProperty("user.home"), userCshScript))) {
                        manager = new CShellManager(scriptFile);
                        manager.initialize();
                        userEnvVarGroup.add(manager);
                    }
                }
                group = userEnvVarGroup;
            }
        }
        catch (IOException ex) {
            throw new ServiceException(ex);
        }
        return group;
    }

    private boolean checkScriptFile(String scriptFile) throws ServiceException {
        boolean result = false;
        File checkFile = new File(scriptFile);
        if (checkFile.exists()) {
            try {
                if (!checkFile.canWrite()) {
                    throw new ServiceException(399, LocalizedStringResolver.resolve("com.installshield.wizard.platform.genericunix.i18n.GenericUnixResources", "systemUtil.cannotWriteScript", new String[]{scriptFile}));
                }
                result = true;
            }
            catch (SecurityException e) {
                throw new ServiceException(e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFilesAfterExit() {
        String gulf = GenericUnixUtils.getgulfHandler();
        if (!new File(gulf).exists()) {
            if (System.getProperty("is.debug") != null) {
                System.out.println("Cleanup script does not exist: " + gulf);
            }
            return;
        }
        this.removeFileToDeleteOnExit(gulf);
        String recurseFileName = this.writeDirsToDelete();
        CoreFileUtils.clearTempFile(recurseFileName);
        this.removeFileToDeleteOnExit(recurseFileName);
        Enumeration e = this.filesToDeleteOnExit();
        if (e.hasMoreElements()) {
            FileOutputStream out = null;
            PrintWriter writer = null;
            try {
                String tempname = CoreFileUtils.createTempFile();
                out = new FileOutputStream(tempname);
                writer = new PrintWriter(out);
                while (e.hasMoreElements()) {
                    String filename = (String)e.nextElement();
                    writer.println(filename);
                    this.removeFileToDeleteOnExit(filename);
                }
                writer.println(gulf);
                writer.println(tempname);
                writer.println(recurseFileName);
                writer.flush();
                writer.close();
                writer = null;
                CoreFileUtils.clearTempFile(tempname);
                StringBuffer cmdBuf = new StringBuffer(256);
                cmdBuf.append(gulf);
                cmdBuf.append(" -F ");
                cmdBuf.append(tempname);
                if (recurseFileName != null && recurseFileName.length() > 0) {
                    cmdBuf.append(" -R ");
                    cmdBuf.append(recurseFileName);
                }
                if (System.getProperty("is.debug") != null) {
                    cmdBuf.append(" -d");
                }
                String cmd = cmdBuf.toString();
                Runtime.getRuntime().exec(cmd);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeDirsToDelete() {
        FileOutputStream out = null;
        PrintWriter writer = null;
        String tempdirs = "";
        try {
            Enumeration e = super.directoriesToRecursivelyDeleteOnExit();
            tempdirs = CoreFileUtils.createTempFile();
            out = new FileOutputStream(tempdirs);
            writer = new PrintWriter(out);
            while (e.hasMoreElements()) {
                String filename = (String)e.nextElement();
                writer.println(filename);
                this.removeFileToDeleteOnExit(filename);
            }
        }
        catch (IOException e) {
            if (System.getProperty("is.debug") != null) {
                System.out.println("Unable to write file containing directories to recursively delete: " + e);
                e.printStackTrace();
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return tempdirs;
    }

    static {
        envVarsCleanedUp = false;
    }
}

