/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.genericunix.utils;

import com.installshield.boot.CoreFileUtils;
import com.installshield.wizard.platform.common.util.NativeObject;
import com.installshield.wizard.platform.common.util.NativeObjectImpl;
import com.installshield.wizard.platform.genericunix.utils.GenericUnixUtils;
import com.installshield.wizard.service.ServiceException;
import java.io.IOException;
import java.net.URL;

public class GenericUnixShellInterface {
    private static NativeObject nativeObject;
    private static boolean initialized;

    private GenericUnixShellInterface() {
    }

    public static NativeObject getNativeObject() {
        return nativeObject;
    }

    public static boolean initialize(URL scriptLocation) throws IOException, ServiceException {
        if (nativeObject == null) {
            String script = CoreFileUtils.createTempFile(scriptLocation);
            Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "chmod 744 " + script});
            try {
                p.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            nativeObject = new NativeObjectImpl(script);
            GenericUnixUtils.debug("shell script is initialized at location =" + script);
            initialized = true;
        }
        return initialized;
    }

    public static void shutDown() {
        GenericUnixUtils.debug("native object is shutting down");
        nativeObject.destroy();
    }

    static {
        initialized = false;
    }
}

