/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.genericunix.utils;

import com.installshield.boot.CoreFileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class GenericUnixUtils {
    private static final String guShellScriptSupport = "gushellsupport.sh";
    private static final String guLauncherScript = "scriptlauncherstub.sh";
    private static final String gulockedFileSupport = "gulf.sh";
    private static final String verifyJar = "Verify.jar";
    private static String gulfHandler;

    public static String getGenericUnixShellScriptSupport() {
        return guShellScriptSupport;
    }

    public static String getGenericUnixServiceResHome() {
        return "reslib/genericunixppk/";
    }

    public static String getGenericUnixLockedFileSupport() {
        return gulockedFileSupport;
    }

    public static String getPlatformLauncherResource() {
        return GenericUnixUtils.getGenericUnixServiceResHome() + guLauncherScript;
    }

    public static String getVerifyClassResource() {
        return GenericUnixUtils.getGenericUnixServiceResHome() + verifyJar;
    }

    public static void initializeLockedFilesHandlerSupport(URL resource, String handler) throws IOException {
        if (resource != null) {
            gulfHandler = CoreFileUtils.createTempFile(resource, handler);
        }
        CoreFileUtils.clearTempFile(gulfHandler);
        CoreFileUtils.clearTempFile(new File(gulfHandler).getParent());
        Runtime.getRuntime().exec(new String[]{"sh", "-c", "chmod 744 " + gulfHandler});
    }

    public static String getgulfHandler() {
        return gulfHandler;
    }

    public static void debug(String s) {
        if (System.getProperty("genericunix.debug") != null) {
            System.out.println("gu.dbg: " + s);
        }
    }
}

