/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.hpux;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.LibraryLoader;
import com.installshield.util.regex.RegexUtil;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.WizardServicesImpl;
import com.zerog.interfaces.util.regex.RegExprSyntaxException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class HpuxUtils {
    private static final String PPK_SUB_DIR = "hpuxppk";
    private static final String PPK_CLASS_RES_DIR = "reslib/hpuxppk";
    private static final String NATIVE_LIB_NAME = "libhpuxppk.1";
    private static final String JUDY_LIB_NAME = "libJudy";
    private static final String LAUNCHER_NAME = "scriptlauncherstub.sh";
    private static final String RMLF_EXE = "rmlf.sh";
    private static final String PARISC_NATIVE_LIB = "parisc/libhpuxppk.1";
    private static final String PARISC_JUDY_LIB = "parisc/libJudy.1";
    private static final String IA64N_NATIVE_LIB = "ia64n/libhpuxppk.1";
    private static final String IA64N_JUDY_LIB = "ia64n/libJudy.1";
    private static final String IA64W_NATIVE_LIB = "ia64w/libhpuxppk.1";
    private static final String IA64W_JUDY_LIB = "ia64w/libJudy.1";
    private static final String JVM_VERIFY_CLASS_RESOURCE = "Verify.jar";
    private static int score = -1;
    private static Vector osName = new Vector();
    private static Vector osArch = new Vector();
    private static Vector osVers10 = new Vector();
    private static Vector osVers11 = new Vector();
    private static String archDir;
    private static String archSubDir;
    private static String rmlfDest;
    private static boolean libLoaded;
    public static final String HPUX_1020_PARISC_ID = "HPUX_1020_PARISC_ID";
    public static final String HPUX_11x_PARISC_ID = "HPUX_11x_PARISC_ID";
    public static final String HPUX_11x_IA64_ID = "HPUX_11x_IA64_ID";

    private static void say(String s) {
        String debug = System.getProperty("is.debug");
        if (debug != null && debug.length() > 0) {
            System.out.println("HpuxUtils: " + s);
        }
    }

    public static int getCompatibilityScore() {
        HpuxUtils.say("getCompatibilityScore()");
        if (score == -1) {
            score = HpuxUtils.isSystemCompatible(osVers10) || HpuxUtils.isSystemCompatible(osVers11) ? 5 : 0;
        }
        HpuxUtils.say("  score = " + score);
        return score;
    }

    public static int getHpux10CompatibilityScore() {
        int result = 0;
        HpuxUtils.say("getHpux10CompatibilityScore()");
        if (HpuxUtils.isSystemCompatible(osVers10)) {
            result = 5;
        }
        HpuxUtils.say("  result = " + result);
        return result;
    }

    public static int getHpux11CompatibilityScore() {
        int result = 0;
        HpuxUtils.say("getHpux11CompatibilityScore()");
        if (HpuxUtils.isSystemCompatible(osVers11)) {
            result = 5;
        }
        HpuxUtils.say("  result = " + result);
        return result;
    }

    private static boolean containsStringLike(Vector vec, String like) {
        int ii = 0;
        boolean found = false;
        while (!found && ii < vec.size()) {
            HpuxUtils.say("Comparing " + vec.elementAt(ii) + " to " + like);
            if (like.toLowerCase().indexOf(((String)vec.elementAt(ii)).toLowerCase()) >= 0) {
                found = true;
                HpuxUtils.say("  match = true");
                continue;
            }
            ++ii;
            HpuxUtils.say("  match = false");
        }
        return found;
    }

    private static boolean isSystemCompatible(Vector osVers) {
        boolean isCompatible = false;
        if (HpuxUtils.containsStringLike(osName, System.getProperty("os.name")) && HpuxUtils.containsStringLike(osArch, System.getProperty("os.arch"))) {
            Enumeration e = osVers.elements();
            String rev = System.getProperty("os.version");
            try {
                while (e.hasMoreElements() && !isCompatible) {
                    String pat = (String)e.nextElement();
                    HpuxUtils.say("  nextElement: " + pat);
                    if (!RegexUtil.getInstance().matches(rev, pat)) continue;
                    isCompatible = true;
                    HpuxUtils.say("  match = true");
                }
            }
            catch (RegExprSyntaxException ex) {
                ex.printStackTrace();
                HpuxUtils.say("Got exception from regular expression : " + ex);
            }
        }
        return isCompatible;
    }

    public static String getPlatformLauncherBuildResource() {
        String res = PPK_SUB_DIR + File.separator + LAUNCHER_NAME;
        return res;
    }

    public static String getVerifyClassBuildResource() {
        return PPK_SUB_DIR + File.separator + JVM_VERIFY_CLASS_RESOURCE;
    }

    public static String getPlatformLauncherResource() {
        String res = PPK_CLASS_RES_DIR + File.separator + LAUNCHER_NAME;
        return res;
    }

    public static String getVerifyClassResource() {
        return PPK_CLASS_RES_DIR + File.separator + JVM_VERIFY_CLASS_RESOURCE;
    }

    public static void loadLibrary(WizardServices services) {
        if (!libLoaded) {
            try {
                String resourceDir = "";
                HpuxUtils.say(" loadLibrary() - archDir value: " + archDir);
                HpuxUtils.say(" loadLibrary() - archSubDir value: " + archSubDir);
                if ("ia64n".equals(archDir) || "ia64w".equals(archDir)) {
                    resourceDir = PPK_CLASS_RES_DIR + File.separator + archDir;
                }
                if ("parisc".equals(archDir) && "".equals(archSubDir)) {
                    resourceDir = PPK_CLASS_RES_DIR + File.separator + archDir;
                } else if ("pariscn".equals(archSubDir) || "pariscw".equals(archSubDir)) {
                    resourceDir = PPK_CLASS_RES_DIR + File.separator + archSubDir;
                }
                String judyLib = resourceDir + File.separator + JUDY_LIB_NAME + ".1";
                String nativeLib = resourceDir + File.separator + NATIVE_LIB_NAME;
                String rmlfExe = PPK_CLASS_RES_DIR + File.separator + RMLF_EXE;
                HpuxUtils.say("loadLibrary() " + judyLib + " " + nativeLib + " " + rmlfExe);
                URL judySrc = ((WizardServicesImpl)services).getServiceResource(judyLib);
                URL nativeSrc = ((WizardServicesImpl)services).getServiceResource(nativeLib);
                URL rmlfSrc = ((WizardServicesImpl)services).getServiceResource(rmlfExe);
                String judyDest = HpuxUtils.createFile(judySrc, "/usr/lib/" + HpuxUtils.getArchSubDir() + JUDY_LIB_NAME + HpuxUtils.getArchExt());
                String nativeDest = CoreFileUtils.createTempFile(nativeSrc, NATIVE_LIB_NAME);
                rmlfDest = CoreFileUtils.createTempFile(rmlfSrc, RMLF_EXE);
                CoreFileUtils.clearTempFile(rmlfDest);
                CoreFileUtils.clearTempFile(new File(rmlfDest).getParent());
                String cmd = "/usr/bin/chmod ugo+r-w+x " + judyDest + " " + nativeDest + " " + rmlfDest;
                HpuxUtils.say("  cmd:  " + cmd);
                Process chmod = Runtime.getRuntime().exec(cmd);
                int status = chmod.waitFor();
                if (status != 0) {
                    services.logEvent(services, "err", "Could not change permissions on " + judyDest + " and " + nativeDest + ": " + status);
                }
                HpuxUtils.say("  status:  " + status);
                LibraryLoader.loadLibrary(judyDest);
                HpuxUtils.say(" judydest loaded successfully, its value being: " + judyDest);
                LibraryLoader.loadLibrary(nativeDest);
                HpuxUtils.say(" nativeDest loaded successfully, its value being: " + nativeDest);
                libLoaded = true;
            }
            catch (Exception ex) {
                services.logEvent(services, "err", ex);
            }
        }
    }

    private static String createFile(URL url, String path) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            HpuxUtils.say("createFile: file already exists: " + path);
            return file.getAbsolutePath();
        }
        CoreFileUtils.addTempFile(file.getAbsolutePath());
        InputStream inputstream = url.openStream();
        FileOutputStream fileoutputstream = new FileOutputStream(file);
        CoreFileUtils.copy(inputstream, fileoutputstream);
        inputstream.close();
        fileoutputstream.close();
        HpuxUtils.say("createFile: created at: " + path);
        return file.getAbsolutePath();
    }

    private static String getArchExt() {
        return archDir.equals("parisc") ? ".sl" : ".so";
    }

    private static String getArchSubDir() {
        if (archDir.equals("ia64n")) {
            return "hpux32/";
        }
        if (archDir.equals("ia64w")) {
            return "hpux64/";
        }
        if (archSubDir.equals("pariscw")) {
            return "pa20_64/";
        }
        if (archSubDir.equals("pariscn")) {
            return "pa20_32/";
        }
        return "";
    }

    public static String getLockedFileRemover() {
        return rmlfDest;
    }

    static {
        archSubDir = "";
        rmlfDest = null;
        libLoaded = false;
        osName.addElement("HP-UX");
        osArch.addElement("PA-RISC");
        osArch.addElement("PA_RISC");
        osArch.addElement("IA64");
        osVers11.addElement("^.\\.11\\.22");
        osVers11.addElement("^.\\.11\\.23");
        osVers11.addElement("^.\\.1[1-2]\\..+");
        String arch = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
        try {
            if (RegexUtil.getInstance().matches(arch, "pa.?risc.*")) {
                archDir = "parisc";
                if (RegexUtil.getInstance().matches(arch, "pa.?risc...w")) {
                    archSubDir = "pariscw";
                } else if (RegexUtil.getInstance().matches(arch, "pa.?risc...")) {
                    archSubDir = "pariscn";
                }
            } else if (RegexUtil.getInstance().matches(arch, "ia.?64.*")) {
                archDir = "ia64n";
                if (RegexUtil.getInstance().matches(arch, "ia.?64w")) {
                    archDir = "ia64w";
                }
            } else {
                archDir = "";
            }
        }
        catch (RegExprSyntaxException ex) {
            ex.printStackTrace();
        }
    }
}

