/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.hpux.service.file;

import com.installshield.wizard.platform.hpux.service.file.FileSysTabEnt;
import com.installshield.wizard.service.ServiceException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class FileSysTable {
    private String filename = null;
    private Vector entries = null;
    private String[] mountpts = null;

    public FileSysTable(String filename) throws ServiceException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            this.filename = filename;
            this.entries = new Vector(15, 8);
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                FileSysTabEnt entry = new FileSysTabEnt(line);
                this.entries.addElement(entry);
            }
        }
        catch (FileNotFoundException e) {
            throw new ServiceException(e);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        this.mountpts = new String[this.entries.size()];
        Enumeration e = this.entries.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            this.mountpts[i++] = ((FileSysTabEnt)e.nextElement()).getMountPt();
        }
    }

    public String[] getMountPts() {
        return this.mountpts;
    }

    public FileSysTabEnt getEntry(String partition) throws ServiceException {
        for (int i = 0; i < this.mountpts.length; ++i) {
            if (!this.mountpts[i].equals(partition)) continue;
            return (FileSysTabEnt)this.entries.elementAt(i);
        }
        throw new ServiceException(314, "Invalid partition name: " + partition);
    }
}

