/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.hpux.service.file;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.CommandUtils;
import com.installshield.util.FileAttributes;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.common.util.GenericUnixCommands;
import com.installshield.wizard.platform.common.util.GenericUnixFileAttributes;
import com.installshield.wizard.platform.hpux.HpuxUtils;
import com.installshield.wizard.platform.hpux.service.file.FileSysTabEnt;
import com.installshield.wizard.platform.hpux.service.file.FileSysTable;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileServiceImplementor;
import com.installshield.wizard.service.file.PureJavaFileServiceImpl;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.File;

public class HpuxFileServiceImpl
extends PureJavaFileServiceImpl
implements FileServiceImplementor {
    private FileSysTable mnttab = null;

    private void say(String s) {
        String debug = System.getProperty("is.debug");
        if (debug != null && debug.length() > 0) {
            System.out.println("HpuxFileService: " + s);
        }
    }

    public void initialized() {
        super.initialized();
        HpuxUtils.loadLibrary(this.getServices());
    }

    public int getSystemCompatibility() {
        return HpuxUtils.getCompatibilityScore();
    }

    protected String getLogFileDirectory() {
        return File.separator + "var" + File.separator + "adm";
    }

    protected String getStandardInstallDirectory() throws ServiceException {
        return File.separator + "opt";
    }

    protected String getTempDirectory() throws ServiceException {
        return File.separator + "tmp";
    }

    private FileSysTable getMountTab() throws ServiceException {
        if (this.mnttab == null) {
            String tabname = File.separator + "etc" + File.separator + "mnttab";
            this.mnttab = new FileSysTable(tabname);
        }
        return this.mnttab;
    }

    public String[] getPartitionNames() throws ServiceException {
        return this.getMountTab().getMountPts();
    }

    public String getPartitionFormat(String partition) throws ServiceException {
        return this.getMountTab().getEntry(partition).getFSType();
    }

    public native long getPartitionFreeSpace(String var1) throws ServiceException;

    public long getPartitionFreeSpace(String partition, long requiredBytes) throws ServiceException {
        return this.getPartitionFreeSpace(partition);
    }

    public int getPartitionType(String partition) throws ServiceException {
        FileSysTabEnt entry = this.getMountTab().getEntry(partition);
        if (entry.getFSType().equals("cdfs")) {
            return 2;
        }
        return 1;
    }

    public native boolean supportsLongFileNames(String var1) throws ServiceException;

    public native String getFileOwner(String var1) throws ServiceException;

    public native String getFileOwnerGroup(String var1) throws ServiceException;

    public FileAttributes getFileAttributes(String file) throws ServiceException {
        return GenericUnixFileAttributes.getAttributeObject(file, this.getFileMode(file));
    }

    public void setFileCreated(String file, long created) {
    }

    public native void setFileModified(String var1, long var2) throws ServiceException;

    public native void setFileTimes(String var1, long var2, long var4, long var6) throws ServiceException;

    private native int getFileMode(String var1) throws ServiceException;

    private native void setFileMode(String var1, int var2) throws ServiceException;

    public void setFileAttributes(String file, FileAttributes attributes) throws ServiceException {
        this.setFileMode(file, GenericUnixFileAttributes.getMode(attributes));
    }

    public void setFileExecutable(String file) throws ServiceException {
        int mode = this.getFileMode(file);
        this.setFileMode(file, mode |= GenericUnixFileAttributes.S_IXUSR | GenericUnixFileAttributes.S_IXGRP | GenericUnixFileAttributes.S_IXOTH);
    }

    public native void setFileOwner(String var1, String var2) throws ServiceException;

    public native void setFileOwnerGroup(String var1, String var2) throws ServiceException;

    private native String hpuxCopyFile(String var1, String var2, boolean var3) throws ServiceException;

    public int copyFile(String srcFileName, String dstFileName, boolean overwrite) throws ServiceException {
        this.say("copyFile(" + srcFileName + ", " + dstFileName + ", " + overwrite + ")");
        String backname = this.hpuxCopyFile(srcFileName, dstFileName, overwrite);
        if (backname != null) {
            this.say("adding " + backname + " to deleteFileOnExit list");
            SystemUtilService service = (SystemUtilService)this.getServices().getService(SystemUtilService.NAME);
            if (service != null) {
                service.deleteFileOnExit(backname);
            }
        }
        return 0;
    }

    private native String hpuxMoveFile(String var1, String var2, boolean var3) throws ServiceException;

    public int moveFile(String srcFileName, String dstFileName, boolean overwrite) throws ServiceException {
        this.say("moveFile(" + srcFileName + ", " + dstFileName + ", " + overwrite + ")");
        String backname = this.hpuxMoveFile(srcFileName, dstFileName, overwrite);
        if (backname != null) {
            this.say("adding " + backname + " to deleteFileOnExit list");
            SystemUtilService service = (SystemUtilService)this.getServices().getService(SystemUtilService.NAME);
            if (service != null) {
                service.deleteFileOnExit(backname);
            }
        }
        return 0;
    }

    private native String hpuxDeleteFile(String var1) throws ServiceException;

    public int deleteFile(String fileName) throws ServiceException {
        this.say("deleteFile(" + fileName + ")");
        String backname = this.hpuxDeleteFile(fileName);
        if (backname != null) {
            this.say("adding " + backname + " to deleteFileOnExit list");
            SystemUtilService service = (SystemUtilService)this.getServices().getService(SystemUtilService.NAME);
            if (service != null) {
                service.deleteFileOnExit(backname);
            }
            return 1;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public int deleteDirectory(String directory, boolean ifEmpty, boolean includeSubDirs) throws ServiceException {
        returnValue = 0;
        error = false;
        errorMessage = "";
        dirName = this.createFileName(this.getCurrentDirectory(), directory);
        if (this.fileExists(dirName) && this.isDirectory(dirName) && this.getParent(dirName) == null) {
            throw new ServiceException(305, "deleteDirectory cannot be used to delete the root directory");
        }
        if (this.isDirectory(dirName)) {
            if (!ifEmpty && !includeSubDirs) {
                try {
                    dirCmdString = CoreFileUtils.appendSeparator(dirName, this.getSeparator()) + "*";
                    info = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -f " + dirCmdString});
                    if (info.getExitCode() == 0) {
                        info = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir " + dirName});
                        if (info.getExitCode() == 0) ** GOTO lbl42
                        error = true;
                        errorMessage = info.getStderr();
                    }
                    error = true;
                    errorMessage = info.getStderr();
                }
                catch (Exception genErr) {
                    throw new ServiceException(genErr);
                }
            } else if (ifEmpty && !includeSubDirs) {
                try {
                    info = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir " + dirName});
                    if (info.getExitCode() == 0) ** GOTO lbl42
                    error = true;
                    errorMessage = info.getStderr();
                }
                catch (Exception genErr) {
                    throw new ServiceException(genErr);
                }
            } else if (!ifEmpty && includeSubDirs) {
                try {
                    info = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -rf " + dirName});
                    if (info.getExitCode() == 0) ** GOTO lbl42
                    error = true;
                    errorMessage = info.getStderr();
                }
                catch (Exception genErr) {
                    throw new ServiceException(genErr);
                }
            } else {
                returnValue = super.deleteDirectory(directory, ifEmpty, includeSubDirs);
            }
        }
lbl42:
        // 10 sources

        if (error) {
            throw new ServiceException(2, "Error deleting directory: " + errorMessage);
        }
        return returnValue;
    }

    public void validateFileName(String fileName) throws ServiceException {
        String invalidChars = ":*?\"<>|^!";
        for (int i = 0; i < fileName.length(); ++i) {
            if (invalidChars.indexOf(fileName.charAt(i)) == -1) continue;
            throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "FileServiceImpl.invalidCharacters", new String[]{invalidChars}));
        }
    }

    public native void setSystemUMask(int var1) throws ServiceException;

    public native int getSystemUMask() throws ServiceException;

    public void createSymbolicLink(String target, String linkName, boolean forceLink) throws ServiceException {
        GenericUnixCommands.createSymbolicLink(target, linkName, forceLink);
    }

    public void removeSymbolicLink(String linkName) throws ServiceException {
        GenericUnixCommands.removeSymbolicLink(linkName);
    }
}

