/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.hpux.service.file;

import com.installshield.util.FileAttributes;

public class UnixFileAttrs {
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_ISVTX = 512;
    public static final int S_IRWXU = 448;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRWXG = 56;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IRWXO = 7;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;

    public static FileAttributes getAttributeObject(int mode) {
        FileAttributes attributes = new FileAttributes();
        if ((mode & 0x100) == 256) {
            attributes.setAttributeState(1, true);
        }
        if ((mode & 0x20) == 32) {
            attributes.setAttributeState(8, true);
        }
        if ((mode & 4) == 4) {
            attributes.setAttributeState(64, true);
        }
        if ((mode & 0x80) == 128) {
            attributes.setAttributeState(2, true);
        }
        if ((mode & 0x10) == 16) {
            attributes.setAttributeState(16, true);
        }
        if ((mode & 2) == 2) {
            attributes.setAttributeState(128, true);
        }
        if ((mode & 0x40) == 64) {
            attributes.setAttributeState(4, true);
        }
        if ((mode & 8) == 8) {
            attributes.setAttributeState(32, true);
        }
        if ((mode & 1) == 1) {
            attributes.setAttributeState(256, true);
        }
        return attributes;
    }

    public static FileAttributes getAttributeObject(String filename, int mode) {
        FileAttributes attributes = UnixFileAttrs.getAttributeObject(mode);
        if (filename.charAt(0) == '.') {
            attributes.setAttributeState(512, true);
        }
        return attributes;
    }

    public static String getAttributeString(int mode) {
        StringBuffer attributes = new StringBuffer();
        if ((mode & 0x100) == 256) {
            attributes.append("rU");
        }
        if ((mode & 0x20) == 32) {
            attributes.append("rG");
        }
        if ((mode & 4) == 4) {
            attributes.append("rO");
        }
        if ((mode & 0x80) == 128) {
            attributes.append("wU");
        }
        if ((mode & 0x10) == 16) {
            attributes.append("wG");
        }
        if ((mode & 2) == 2) {
            attributes.append("wO");
        }
        if ((mode & 0x40) == 64) {
            attributes.append("xU");
        }
        if ((mode & 8) == 8) {
            attributes.append("xG");
        }
        if ((mode & 1) == 1) {
            attributes.append("xO");
        }
        if ((mode & 0x800) == 2048) {
            attributes.append("s");
        }
        if ((mode & 0x400) == 1024) {
            attributes.append("g");
        }
        return attributes.toString();
    }

    public static int getMode(FileAttributes attributes) {
        int mode = 0;
        if (attributes.getAttributeState(1)) {
            mode |= 0x100;
        }
        if (attributes.getAttributeState(8)) {
            mode |= 0x20;
        }
        if (attributes.getAttributeState(64)) {
            mode |= 4;
        }
        if (attributes.getAttributeState(2)) {
            mode |= 0x80;
        }
        if (attributes.getAttributeState(16)) {
            mode |= 0x10;
        }
        if (attributes.getAttributeState(128)) {
            mode |= 2;
        }
        if (attributes.getAttributeState(4)) {
            mode |= 0x40;
        }
        if (attributes.getAttributeState(32)) {
            mode |= 8;
        }
        if (attributes.getAttributeState(256)) {
            mode |= 1;
        }
        return mode;
    }

    public static int getMode(String attributes) {
        int mode = 0;
        if (attributes.indexOf("rU") != -1) {
            mode |= 0x100;
        }
        if (attributes.indexOf("rG") != -1) {
            mode |= 0x20;
        }
        if (attributes.indexOf("rO") != -1) {
            mode |= 4;
        }
        if (attributes.indexOf("wU") != -1) {
            mode |= 0x80;
        }
        if (attributes.indexOf("wG") != -1) {
            mode |= 0x10;
        }
        if (attributes.indexOf("wO") != -1) {
            mode |= 2;
        }
        if (attributes.indexOf("xU") != -1) {
            mode |= 0x40;
        }
        if (attributes.indexOf("xG") != -1) {
            mode |= 8;
        }
        if (attributes.indexOf("xO") != -1) {
            mode |= 1;
        }
        if (attributes.indexOf("s") != -1) {
            mode |= 0x800;
        }
        if (attributes.indexOf("g") != -1) {
            mode |= 0x400;
        }
        return mode;
    }
}

