/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.hpux.service.security;

import com.installshield.util.CommandResult;
import com.installshield.util.CommandUtils;
import com.installshield.wizard.platform.common.util.GenericUnixCommands;
import com.installshield.wizard.platform.common.util.UnixCrypt;
import com.installshield.wizard.platform.hpux.HpuxUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.security.GroupSpecification;
import com.installshield.wizard.service.security.PureJavaSecurityServiceImpl;
import com.installshield.wizard.service.security.SecurityServiceImplementor;
import com.installshield.wizard.service.security.UserSpecification;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class HpuxSecurityServiceImpl
extends PureJavaSecurityServiceImpl
implements SecurityServiceImplementor {
    protected void initialized() {
        super.initialized();
        HpuxUtils.loadLibrary(this.getServices());
    }

    public int getSystemCompatibility() {
        return HpuxUtils.getCompatibilityScore();
    }

    public native boolean isCurrentUserAdmin() throws ServiceException;

    private void throwJavaServExcep(Process proc, String errmsg) throws ServiceException {
        String line;
        try {
            InputStream err = proc.getErrorStream();
            InputStreamReader in = new InputStreamReader(err);
            BufferedReader br = new BufferedReader(in);
            line = br.readLine();
        }
        catch (IOException e) {
            throw new ServiceException(2, errmsg);
        }
        throw new ServiceException(2, errmsg + ": " + line);
    }

    public void createUser(UserSpecification user) throws ServiceException {
        GenericUnixCommands.createUser(user);
        String password = user.getPassword();
        if (password != null) {
            CommandResult result;
            String encPassword = UnixCrypt.crypt(UnixCrypt.getRandomSalt(), password);
            String[] commandArray = new String[]{"-p", encPassword, user.getUserName()};
            try {
                result = CommandUtils.executeCommand("/usr/sam/lbin/usermod.sam", commandArray);
            }
            catch (Exception e) {
                throw new ServiceException(e);
            }
            if (result.getExitCode() != 0) {
                throw new ServiceException(315, result.getStderr());
            }
        }
    }

    public void deleteUser(String user) throws ServiceException {
        try {
            Process proc = Runtime.getRuntime().exec("/usr/sbin/userdel " + user);
            int status = proc.waitFor();
            if (status != 0) {
                this.throwJavaServExcep(proc, "Could not delete user " + user);
            }
        }
        catch (InterruptedException e) {
            throw new ServiceException(e);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public void createGroup(GroupSpecification group) throws ServiceException {
        StringBuffer cmd = new StringBuffer("/usr/sbin/groupadd ");
        cmd.append(group.getGroupName());
        try {
            Process proc = Runtime.getRuntime().exec(cmd.toString());
            int status = proc.waitFor();
            switch (status) {
                case 0: 
                case 4: 
                case 9: {
                    break;
                }
                default: {
                    this.throwJavaServExcep(proc, "Could not add group " + group.getGroupName());
                    break;
                }
            }
        }
        catch (InterruptedException e) {
            throw new ServiceException(e);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public void deleteGroup(String group) throws ServiceException {
        try {
            Process proc = Runtime.getRuntime().exec("/usr/sbin/groupdel " + group);
            int status = proc.waitFor();
            switch (status) {
                case 0: 
                case 6: {
                    break;
                }
                default: {
                    this.throwJavaServExcep(proc, "Could not delete group " + group);
                    break;
                }
            }
        }
        catch (InterruptedException e) {
            throw new ServiceException(e);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }
}

