/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.hpux.service.system;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.LockedFilesHandler;
import com.installshield.wizard.platform.common.environment.BourneShellManager;
import com.installshield.wizard.platform.common.environment.CShellManager;
import com.installshield.wizard.platform.common.environment.EnvironmentVariableManagerGroup;
import com.installshield.wizard.platform.common.environment.ScriptEnvironmentVariableManager;
import com.installshield.wizard.platform.hpux.HpuxUtils;
import com.installshield.wizard.platform.hpux.service.system.HpuxEnvironment;
import com.installshield.wizard.platform.hpux.service.system.ProcessEnvironmentVariableManager;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.PureJavaSystemUtilServiceImpl;
import com.installshield.wizard.service.system.SystemUtilServiceImplementor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class HpuxSystemUtilServiceImpl
extends PureJavaSystemUtilServiceImpl
implements SystemUtilServiceImplementor,
LockedFilesHandler {
    private static final String systemCshScript = "/etc/csh.login";
    private static final String userCshScript = ".login";
    private static final String systemBourneScript = "/etc/profile";
    private static final String userBourneScript = ".profile";
    private static EnvironmentVariableManagerGroup userEnvVarGroup;
    private static EnvironmentVariableManagerGroup systemEnvVarGroup;
    private static boolean envVarsCleanedUp;
    private ProcessEnvironmentVariableManager currentProcessEnvVarManager;

    private void say(String s) {
        if (System.getProperty("is.debug") != null) {
            System.out.println("HpuxSystemUtilServiceImpl: " + s);
        }
    }

    public int getSystemCompatibility() {
        return HpuxUtils.getCompatibilityScore();
    }

    public void initialized() {
        this.say("initializing ... ");
        super.initialized();
        FileUtils.setLockedFilesHandler(this);
        HpuxUtils.loadLibrary(this.getServices());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFilesAfterExit() {
        this.say("deleteFilesAfterExit()");
        String rmlf = HpuxUtils.getLockedFileRemover();
        if (!new File(rmlf).exists()) {
            if (System.getProperty("is.debug") != null) {
                this.say("Cleanup script does not exist: " + rmlf);
            }
            return;
        }
        CoreFileUtils.clearTempFile(rmlf);
        this.removeFileToDeleteOnExit(rmlf);
        String recurseFileName = this.writeDirsToDelete();
        CoreFileUtils.clearTempFile(recurseFileName);
        this.removeFileToDeleteOnExit(recurseFileName);
        Enumeration e = this.filesToDeleteOnExit();
        if (e.hasMoreElements()) {
            FileOutputStream out = null;
            PrintWriter writer = null;
            try {
                String tempname = CoreFileUtils.createTempFile();
                out = new FileOutputStream(tempname);
                writer = new PrintWriter(out);
                while (e.hasMoreElements()) {
                    String filename = (String)e.nextElement();
                    writer.println(filename);
                    this.removeFileToDeleteOnExit(filename);
                }
                writer.println(rmlf);
                writer.println(tempname);
                writer.println(recurseFileName);
                String tempDir = null;
                try {
                    tempDir = CoreFileUtils.getParent(tempname);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (tempDir != null) {
                    writer.println(new File(tempDir));
                }
                writer.flush();
                writer.close();
                writer = null;
                CoreFileUtils.clearTempFile(tempname);
                Vector<String> args = new Vector<String>(10);
                args.addElement(rmlf);
                args.addElement("-F");
                args.addElement(tempname);
                if (recurseFileName != null && recurseFileName.length() > 0) {
                    args.addElement("-R");
                    args.addElement(recurseFileName);
                }
                if (System.getProperty("is.debug") != null) {
                    args.addElement("-d");
                }
                String[] cmdArray = new String[args.size()];
                this.say("running cmdArray:");
                for (int ii = 0; ii < args.size(); ++ii) {
                    cmdArray[ii] = (String)args.elementAt(ii);
                    this.say("  " + cmdArray[ii]);
                }
                Process process = Runtime.getRuntime().exec(cmdArray);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeDirsToDelete() {
        FileOutputStream out = null;
        PrintWriter writer = null;
        String tempdirs = "";
        try {
            Enumeration e = super.directoriesToRecursivelyDeleteOnExit();
            tempdirs = CoreFileUtils.createTempFile();
            out = new FileOutputStream(tempdirs);
            writer = new PrintWriter(out);
            while (e.hasMoreElements()) {
                String filename = (String)e.nextElement();
                writer.println(filename);
                this.removeFileToDeleteOnExit(filename);
            }
        }
        catch (IOException e) {
            if (System.getProperty("is.debug") != null) {
                System.out.println("Unable to write file containing directories to recursively delete: " + e);
                e.printStackTrace();
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return tempdirs;
    }

    public String getEnvironmentVariable(String variableName) throws ServiceException {
        return HpuxEnvironment.getProcessEnvironmentVariable(variableName);
    }

    public String getRawEnvironmentVariable(String variableName, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            return group.getVariable(variableName);
        }
        return null;
    }

    public void setEnvironmentVariable(String key, String value) throws ServiceException {
        this.setEnvironmentVariable(key, value, 2);
    }

    public void setEnvironmentVariable(String variableName, String variableValue, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.setVariable(variableName, variableValue);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.setVariable(variableName, variableValue);
    }

    public void deleteEnvironmentVariable(String key) throws ServiceException {
        this.deleteEnvironmentVariable(key, 2);
    }

    public void deleteEnvironmentVariable(String variableName, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.deleteVariable(variableName);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.deleteVariable(variableName);
    }

    public void appendEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.appendVariable(variableName, variableValue, delimiter);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.appendVariable(variableName, variableValue, delimiter);
    }

    public void unAppendEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.unAppendVariable(variableName, variableValue, delimiter);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.unAppendVariable(variableName, variableValue, delimiter);
    }

    public void prependEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.prependVariable(variableName, variableValue, delimiter);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.prependVariable(variableName, variableValue, delimiter);
    }

    public void unPrependEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.unPrependVariable(variableName, variableValue, delimiter);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.unPrependVariable(variableName, variableValue, delimiter);
    }

    private void verifyVariableName(String variableName) throws ServiceException {
        if (variableName == null || variableName.length() == 0) {
            throw new ServiceException(399, LocalizedStringResolver.resolve("com.installshield.wizard.platform.hpux.i18n.HpuxResources", "systemUtil.variableNameRequired"));
        }
    }

    public void cleanup() throws ServiceException {
        if (!envVarsCleanedUp) {
            if (userEnvVarGroup != null) {
                userEnvVarGroup.makeUpdatePersistent();
            }
            if (systemEnvVarGroup != null) {
                systemEnvVarGroup.makeUpdatePersistent();
            }
            envVarsCleanedUp = true;
        }
    }

    private EnvironmentVariableManagerGroup getEnvVarGroup(int level) throws ServiceException {
        EnvironmentVariableManagerGroup group = null;
        ScriptEnvironmentVariableManager manager = null;
        if (this.currentProcessEnvVarManager == null) {
            this.currentProcessEnvVarManager = new ProcessEnvironmentVariableManager();
        }
        try {
            if (level == 1 && System.getProperty("user.name").equals("root")) {
                if (systemEnvVarGroup == null) {
                    systemEnvVarGroup = new EnvironmentVariableManagerGroup();
                    if (this.checkScriptFile(systemBourneScript)) {
                        manager = new BourneShellManager(systemBourneScript);
                        manager.initialize();
                        systemEnvVarGroup.add(manager);
                    }
                    if (this.checkScriptFile(systemCshScript)) {
                        manager = new CShellManager(systemCshScript);
                        manager.initialize();
                        systemEnvVarGroup.add(manager);
                    }
                }
                group = systemEnvVarGroup;
            } else if (level == 2) {
                if (userEnvVarGroup == null) {
                    userEnvVarGroup = new EnvironmentVariableManagerGroup();
                    String scriptFile = CoreFileUtils.createFileName(System.getProperty("user.home"), userBourneScript);
                    if (this.checkScriptFile(scriptFile)) {
                        manager = new BourneShellManager(scriptFile);
                        manager.initialize();
                        userEnvVarGroup.add(manager);
                    }
                    if (this.checkScriptFile(scriptFile = CoreFileUtils.createFileName(System.getProperty("user.home"), userCshScript))) {
                        manager = new CShellManager(scriptFile);
                        manager.initialize();
                        userEnvVarGroup.add(manager);
                    }
                }
                group = userEnvVarGroup;
            }
        }
        catch (IOException ex) {
            throw new ServiceException(ex);
        }
        return group;
    }

    private boolean checkScriptFile(String scriptFile) throws ServiceException {
        boolean result = false;
        File checkFile = new File(scriptFile);
        if (checkFile.exists()) {
            try {
                if (!checkFile.canWrite()) {
                    throw new ServiceException(399, LocalizedStringResolver.resolve("com.installshield.wizard.platform.hpux.i18n.HpuxResources", "systemUtil.cannotWriteScript", new String[]{scriptFile}));
                }
                result = true;
            }
            catch (SecurityException e) {
                throw new ServiceException(e);
            }
        }
        return result;
    }

    static {
        envVarsCleanedUp = false;
    }
}

