/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.macosx;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.service.ServiceException;

public class MacOSXPlatform {
    public static final int MAC_ANY = 1;
    public static final int ARCH_ANY = 1;

    private MacOSXPlatform() {
    }

    public static boolean isCompatibleWith(int nOS, int nArch) throws ServiceException {
        String arch;
        boolean osCompatibility = false;
        boolean archCompatibility = false;
        String osName = System.getProperty("os.name");
        String checkName = "Mac OS X";
        if (osName.length() >= checkName.length() && osName.substring(0, checkName.length()).equalsIgnoreCase(checkName)) {
            if (nOS == 1) {
                osCompatibility = true;
            } else {
                throw new ServiceException(399, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXPlatform.unsupportedOSName", new String[]{osName}));
            }
        }
        if ((arch = System.getProperty("os.arch")).equalsIgnoreCase("ppc") || arch.equalsIgnoreCase("i386")) {
            archCompatibility = nArch == 1;
        }
        return osCompatibility && archCompatibility;
    }
}

