/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.macosx;

import com.installshield.util.LibraryLoader;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.macosx.MacOSXPlatform;
import java.net.URL;

public class MacOSXUtils {
    public static final String JVM_VERIFY_CLASS_NAME = "Verify.jar";
    public static final String LAUNCHER_NAME = "launcher";
    public static final String JVM_KEY = "macosx";
    private static final String JNI_LIBRARY_NAME = "libmacosxppk.jnilib";
    private static final String MACOSX_APPBUNDLE = "AppBundle";
    private static final String CLASS_RESOURCE_DIR = "reslib/macosxppk/";

    public static int getSystemCompatibility() {
        int result = 0;
        try {
            if (MacOSXPlatform.isCompatibleWith(1, 1)) {
                result = 5;
            }
        }
        catch (Exception genErr) {
            genErr.printStackTrace();
        }
        return result;
    }

    public static void loadLibrary(URL libraryURL, String name) {
        try {
            LibraryLoader.loadLibrary(libraryURL, name);
        }
        catch (Throwable ex) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXUtils.cannotLoadJniLibrary", new String[]{libraryURL.toString()}));
            ex.printStackTrace();
        }
    }

    public static String getMacOSXPPKBuildSubdir() {
        return "macosxppk/";
    }

    public static String getMacAppBundleBuildHome() {
        return MACOSX_APPBUNDLE;
    }

    public static String getPlatformLauncherBuildResource() {
        return MacOSXUtils.getMacOSXPPKBuildSubdir() + LAUNCHER_NAME;
    }

    public static String getVerifyClassBuildResource() {
        return MacOSXUtils.getMacOSXPPKBuildSubdir() + JVM_VERIFY_CLASS_NAME;
    }

    public static String getMacOSXPPKSubdir() {
        return "macosxppk/";
    }

    public static String getClassResourceSubdir() {
        return CLASS_RESOURCE_DIR;
    }

    public static String getMacAppBundleHome() {
        return MACOSX_APPBUNDLE;
    }

    public static String getJNILibraryResourceName() {
        return MacOSXUtils.getClassResourceSubdir() + MacOSXUtils.getJNILibraryName();
    }

    public static String getJNILibraryName() {
        return JNI_LIBRARY_NAME;
    }

    public static String getPlatformLauncherResource() {
        return MacOSXUtils.getClassResourceSubdir() + LAUNCHER_NAME;
    }

    public static String getVerifyClassResource() {
        return MacOSXUtils.getClassResourceSubdir() + JVM_VERIFY_CLASS_NAME;
    }
}

