/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.macosx.service.file;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.CommandUtils;
import com.installshield.util.FileAttributes;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.common.util.GenericUnixCommands;
import com.installshield.wizard.platform.common.util.GenericUnixFileAttributes;
import com.installshield.wizard.platform.macosx.MacOSXUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.file.FileServiceImplementor;
import com.installshield.wizard.service.file.PureJavaFileServiceImpl;
import java.io.File;

public class MacOSXFileServiceImpl
extends PureJavaFileServiceImpl
implements FileServiceImplementor {
    private static final short MACOSX_LOCAL_MOUNT_FLAG = 4096;
    private static final String DATA_FILE_NAME = ".DS_Store";

    public int getSystemCompatibility() {
        return MacOSXUtils.getSystemCompatibility();
    }

    protected void initialized() {
        super.initialized();
        try {
            MacOSXUtils.loadLibrary(this.getServiceResource(MacOSXUtils.getJNILibraryResourceName()), MacOSXUtils.getJNILibraryName());
        }
        catch (Exception ex) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "serviceCannotLoadJniLibrary", new String[]{FileService.NAME, MacOSXUtils.getJNILibraryName()}));
            ex.printStackTrace();
        }
    }

    private native void chown(String var1, String var2, String var3) throws ServiceException;

    private native int getFileMode(String var1) throws ServiceException;

    private native void setFileMode(String var1, int var2) throws ServiceException;

    private native short getPartitionMountFlags(String var1) throws ServiceException;

    private native String getPartitionFormatName(String var1) throws ServiceException;

    public native void setFileTimes(String var1, long var2, long var4, long var6) throws ServiceException;

    public void setFileCreated(String fileName, long date) throws ServiceException {
        this.setFileModified(fileName, date);
    }

    public native void setFileModified(String var1, long var2) throws ServiceException;

    protected String getLibraryDirectory() throws ServiceException {
        return File.separator + "usr" + File.separator + "lib";
    }

    protected String getStandardInstallDirectory() throws ServiceException {
        return File.separator + "Applications";
    }

    protected native String getTempDirectory() throws ServiceException;

    public native String[] getPartitionNames() throws ServiceException;

    public native long getPartitionFreeSpace(String var1) throws ServiceException;

    public FileAttributes getFileAttributes(String file) throws ServiceException {
        return GenericUnixFileAttributes.getAttributeObject(file, this.getFileMode(file));
    }

    public void setFileAttributes(String file, FileAttributes attributes) throws ServiceException {
        this.setFileMode(file, GenericUnixFileAttributes.getMode(attributes));
    }

    public void setFileExecutable(String file) throws ServiceException {
        FileAttributes attribs = this.getFileAttributes(file);
        int attribMask = 292;
        attribs.setAttributeState(attribMask, true);
        this.setFileMode(file, GenericUnixFileAttributes.getMode(attribs));
    }

    public native String getFileOwner(String var1) throws ServiceException;

    public void setFileOwner(String file, String userid) throws ServiceException {
        this.chown(file, userid, null);
    }

    public native String getFileOwnerGroup(String var1) throws ServiceException;

    public void setFileOwnerGroup(String file, String groupid) throws ServiceException {
        this.chown(file, null, groupid);
    }

    public boolean supportsLongFileNames(String partition) throws ServiceException {
        return true;
    }

    public int getPartitionType(String partition) throws ServiceException {
        short mountFlags = this.getPartitionMountFlags(partition);
        System.out.println("mountFlags = " + mountFlags);
        int returnValue = (mountFlags & 0x1000) == 4096 ? 1 : 2;
        return returnValue;
    }

    public String getPartitionFormat(String partition) throws ServiceException {
        return this.getPartitionFormatName(partition);
    }

    public native void setSystemUMask(int var1) throws ServiceException;

    public native int getSystemUMask() throws ServiceException;

    protected boolean acceptDirectoryListEntry(String dirName, String fileName, int acceptedType) throws ServiceException {
        if (fileName.trim().equals(DATA_FILE_NAME)) {
            return false;
        }
        return super.acceptDirectoryListEntry(dirName, fileName, acceptedType);
    }

    /*
     * Unable to fully structure code
     */
    public int deleteDirectory(String directory, boolean ifEmpty, boolean includeSubDirs) throws ServiceException {
        returnValue = 0;
        error = false;
        errorMessage = "";
        dirName = this.createFileName(this.getCurrentDirectory(), directory);
        if (this.fileExists(dirName) && this.isDirectory(dirName) && this.getParent(dirName) == null) {
            throw new ServiceException(305, "deleteDirectory cannot be used to delete the root directory");
        }
        if (this.isDirectory(dirName)) {
            if (!ifEmpty && !includeSubDirs) {
                try {
                    dirCmdString = CoreFileUtils.appendSeparator(dirName, this.getSeparator()) + "*";
                    info = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -f \"" + dirCmdString + "\""});
                    if (info.getExitCode() == 0) {
                        info = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir \"" + dirName + "\""});
                        if (info.getExitCode() == 0) ** GOTO lbl43
                        error = true;
                        errorMessage = info.getStderr();
                    }
                    error = true;
                    errorMessage = info.getStderr();
                }
                catch (Exception genErr) {
                    throw new ServiceException(genErr);
                }
            } else if (ifEmpty && !includeSubDirs) {
                try {
                    this.deleteDataFile(dirName);
                    info = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir \"" + dirName + "\""});
                    if (info.getExitCode() == 0) ** GOTO lbl43
                    error = true;
                    errorMessage = info.getStderr();
                }
                catch (Exception genErr) {
                    throw new ServiceException(genErr);
                }
            } else if (!ifEmpty && includeSubDirs) {
                try {
                    info = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -rf \"" + dirName + "\""});
                    if (info.getExitCode() == 0) ** GOTO lbl43
                    error = true;
                    errorMessage = info.getStderr();
                }
                catch (Exception genErr) {
                    throw new ServiceException(genErr);
                }
            } else {
                returnValue = super.deleteDirectory(directory, ifEmpty, includeSubDirs);
            }
        }
lbl43:
        // 10 sources

        if (error) {
            throw new ServiceException(2, "Error deleting directory: " + errorMessage);
        }
        return returnValue;
    }

    protected boolean deleteDirectoryImpl(String directoryName) throws ServiceException {
        this.deleteDataFile(directoryName);
        return new File(directoryName).delete();
    }

    private void deleteDataFile(String directoryName) throws ServiceException {
        String dataFile = this.createFileName(directoryName, DATA_FILE_NAME);
        if (this.fileExists(dataFile)) {
            this.deleteFile(dataFile);
        }
    }

    protected long calculateDirectorySizeImpl(String directoryName) throws ServiceException {
        long directorySize = 0L;
        String dataFile = this.createFileName(directoryName, DATA_FILE_NAME);
        if (this.fileExists(dataFile)) {
            directorySize += (long)this.getFileSize(dataFile);
        }
        return directorySize;
    }

    public void validateFileName(String fileName) throws ServiceException {
        String invalidChars = ":*?\"<>|^!";
        for (int i = 0; i < fileName.length(); ++i) {
            if (invalidChars.indexOf(fileName.charAt(i)) == -1) continue;
            throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "FileServiceImpl.invalidCharacters", new String[]{invalidChars}));
        }
    }

    public void createSymbolicLink(String target, String linkName, boolean forceLink) throws ServiceException {
        GenericUnixCommands.createSymbolicLink(target, linkName, forceLink);
    }
}

