/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.macosx.service.security;

import com.installshield.util.CommandResult;
import com.installshield.util.CommandUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.macosx.MacOSXUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.security.GroupSpecification;
import com.installshield.wizard.service.security.PureJavaSecurityServiceImpl;
import com.installshield.wizard.service.security.SecurityService;
import com.installshield.wizard.service.security.UserSpecification;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MacOSXSecurityServiceImpl
extends PureJavaSecurityServiceImpl {
    private static final String NIUTIL_CMD = "niutil";
    private static final String CREATE_FOLDER = "-create";
    private static final String CREATE_PROP = "-createprop";
    private static final String READ_PROP = "-readprop";
    private static final String MERGE_PROP = "-mergeprop";
    private static final String DESTROY_VAL = "-destroyval";
    private static final String DESTROY_FOLDER = "-destroy";
    private static final String RESYNC_DOMAIN = "-resync";
    private static final String NIREPORT_CMD = "nireport";
    private static final String DEFAULT_DOMAIN = "/";
    private static final String USERS_FOLDER = "/users";
    private static final String GROUPS_FOLDER = "/groups";
    private static final String G_PASSWD_PROP = "passwd";
    private static final String G_NAME_PROP = "name";
    private static final String G_GID_PROP = "gid";
    private static final String G_USERS_PROP = "users";
    private static final String G_NO_GROUP_GID = "-1";
    private static final String G_DEFAULT_PASSWD = "*";
    public static final int G_DEFAULT_GID_START = 501;
    private static final String U_PICTURE_PROP = "picture";
    private static final String U_NAME_PROP = "name";
    private static final String U_PASSWD_PROP = "passwd";
    private static final String U_UID_PROP = "uid";
    private static final String U_GID_PROP = "gid";
    private static final String U_HOME_PROP = "home";
    private static final String U_SHELL_PROP = "shell";
    private static final String U_SHADOW_PASSWD_PROP = "_shadow_passwd";
    private static final String U_HINT_PROP = "hint";
    private static final String U_FULL_NAME_PROP = "realname";
    private static final String U_WRITERS_HINT_PROP = "_writers_hint";
    private static final String U_WRITERS_PASSWD_PROP = "_writers_passwd";
    private static final String U_WRITERS_PICTURE_PROP = "_writers_picture";
    private static final String U_SHARED_DIR_PROP = "sharedDir";
    private static final String U_DEFAULT_PICTURE = "";
    private static final String U_DEFAULT_PASSWD = "";
    private static final String U_DEFAULT_HOME = "";
    private static final String U_DEFAULT_SHELL = "/bin/tcsh";
    private static final String U_DEFAULT_SHADOW_PASSWD = "";
    private static final String U_DEFAULT_HINT = "";
    private static final String U_DEFAULT_WRITERS_HINT = "";
    private static final String U_DEFAULT_SHARED_DIR = "Public";
    public static final int U_DEFAULT_UID_START = 501;

    public int getSystemCompatibility() {
        return MacOSXUtils.getSystemCompatibility();
    }

    protected void initialized() {
        super.initialized();
        try {
            MacOSXUtils.loadLibrary(this.getServiceResource(MacOSXUtils.getJNILibraryResourceName()), MacOSXUtils.getJNILibraryName());
        }
        catch (Exception ex) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "serviceCannotLoadJniLibrary", new String[]{SecurityService.NAME, MacOSXUtils.getJNILibraryName()}));
            ex.printStackTrace();
        }
    }

    public boolean isCurrentUserAdmin() throws ServiceException {
        return "root".equals(System.getProperty("user.name"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUser(UserSpecification user) throws ServiceException {
        String userHome;
        String encryptedPassword;
        String userDefaultGID;
        String newUID;
        try {
            this.verifyNewUserObject(user);
        }
        catch (ServiceException svcErr) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotAddUserGeneral", new String[]{user.getUserName()}), svcErr);
        }
        if (!this.isCurrentUserAdmin()) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotAddUserNotAdmin", new String[]{user.getUserName()}));
        }
        if (this.userExists(user.getUserName())) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotAddUserExistsError", new String[]{user.getUserName()}));
        }
        if (this.userFullNameExists(user.getUserFullName())) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotAddUserFullNameExists", new String[]{user.getUserName(), user.getUserFullName()}));
        }
        Vector undefinedGroupsList = new Vector();
        if (!this.groupsExist(user.getGroups(), undefinedGroupsList)) {
            StringBuffer undefinedGroups = new StringBuffer();
            undefinedGroups.append(undefinedGroupsList.elementAt(0));
            for (int i = 1; i < undefinedGroupsList.size(); ++i) {
                undefinedGroups.append(", " + undefinedGroupsList.elementAt(i));
            }
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotAddUserGroupsUndefinedError", new String[]{user.getUserName(), undefinedGroups.toString()}));
        }
        try {
            newUID = this.getNewUID();
            userDefaultGID = this.getUserDefaultGID(user.getGroups());
            encryptedPassword = user.getPassword() == null || user.getPassword().trim().length() == 0 ? "" : this.encryptPassword(user.getPassword());
            userHome = user.getHomeDirectory() == null || user.getHomeDirectory().trim().length() == 0 ? "" : user.getHomeDirectory();
        }
        catch (ServiceException svcErr) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotAddUserGeneral", new String[]{user.getUserName()}), svcErr);
        }
        String userFolder = "/users/" + user.getUserName();
        int exitCode = this.createFolder(userFolder);
        if (exitCode == 0) {
            try {
                exitCode = this.createProperty(userFolder, "name", user.getUserName());
                if (exitCode == 0) {
                    exitCode = this.createProperty(userFolder, U_UID_PROP, newUID);
                }
                if (exitCode == 0) {
                    exitCode = this.createProperty(userFolder, "gid", userDefaultGID);
                }
                if (exitCode == 0) {
                    exitCode = this.createProperty(userFolder, U_FULL_NAME_PROP, user.getUserFullName());
                }
                if (exitCode == 0) {
                    exitCode = this.createProperty(userFolder, "passwd", encryptedPassword);
                }
                if (exitCode == 0) {
                    exitCode = this.createProperty(userFolder, U_HOME_PROP, userHome);
                }
                if (exitCode == 0) {
                    exitCode = this.createProperty(userFolder, U_SHELL_PROP, U_DEFAULT_SHELL);
                }
                if (exitCode == 0) {
                    exitCode = this.createProperty(userFolder, U_SHARED_DIR_PROP, U_DEFAULT_SHARED_DIR);
                }
                if (exitCode == 0) {
                    exitCode = this.createProperty(userFolder, U_SHADOW_PASSWD_PROP, "");
                }
                if (exitCode == 0) {
                    exitCode = this.createProperty(userFolder, U_PICTURE_PROP, "");
                }
                if (exitCode == 0) {
                    exitCode = this.createProperty(userFolder, U_HINT_PROP, "");
                }
                if (exitCode == 0) {
                    exitCode = this.createProperty(userFolder, U_WRITERS_HINT_PROP, "");
                }
                if (exitCode == 0) {
                    exitCode = this.createProperty(userFolder, U_WRITERS_PASSWD_PROP, user.getUserName());
                }
                if (exitCode == 0) {
                    exitCode = this.createProperty(userFolder, U_WRITERS_PICTURE_PROP, user.getUserName());
                }
            }
            catch (ServiceException svcErr) {
                exitCode = -1;
                throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotAddUserGeneral", new String[]{user.getUserName()}), svcErr);
            }
            finally {
                if (exitCode != 0) {
                    try {
                        this.destroyFolder(userFolder);
                    }
                    catch (Exception genErr) {}
                }
                try {
                    this.resyncDomain();
                }
                catch (Exception genErr) {}
            }
        }
        if (exitCode != 0) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotAddUserExitCode", new String[]{user.getUserName(), Integer.toString(exitCode)}));
        }
        if (exitCode == 0) {
            try {
                Vector failedGroupsList = new Vector();
                if (!this.addUserToGroups(user.getUserName(), user.getGroups(), failedGroupsList)) {
                    StringBuffer failedGroups = new StringBuffer();
                    failedGroups.append(failedGroupsList.elementAt(0));
                    for (int i = 1; i < failedGroupsList.size(); ++i) {
                        failedGroups.append(", " + failedGroupsList.elementAt(i));
                    }
                    ServiceException svcErr = new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.addUserGroupAddWarning", new String[]{user.getUserName(), failedGroups.toString()}));
                    svcErr.setSeverity(1);
                    throw svcErr;
                }
            }
            finally {
                try {
                    this.resyncDomain();
                }
                catch (Exception genErr) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUser(String userName) throws ServiceException {
        if (userName != null && userName.trim().length() != 0) {
            String userFolder = "/users/" + userName;
            if (!this.isCurrentUserAdmin()) {
                throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotDeleteUserNotAdmin", new String[]{userName}));
            }
            int exitCode = 0;
            if (this.folderExists(USERS_FOLDER, userName)) {
                try {
                    String[] userGroups = this.getUserGroups(userName);
                    Vector failedGroupsList = new Vector();
                    if (!this.removeUserFromGroups(userName, userGroups, failedGroupsList)) {
                        StringBuffer failedGroups = new StringBuffer();
                        failedGroups.append(failedGroupsList.elementAt(0));
                        for (int i = 1; i < failedGroupsList.size(); ++i) {
                            failedGroups.append(", " + failedGroupsList.elementAt(i));
                        }
                        ServiceException svcErr = new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotDeleteUserRemoveFromGroupError", new String[]{userName, failedGroups.toString()}));
                        throw svcErr;
                    }
                    exitCode = this.destroyFolder(userFolder);
                }
                finally {
                    try {
                        this.resyncDomain();
                    }
                    catch (Exception genErr) {}
                }
            }
            if (exitCode != 0) {
                throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotDeleteUserExitCode", new String[]{userName, Integer.toString(exitCode)}));
            }
        }
    }

    public void createGroup(GroupSpecification groupSpec) throws ServiceException {
        String newGID;
        try {
            this.verifyNewGroupObject(groupSpec);
        }
        catch (ServiceException svcErr) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotAddGroupGeneral", new String[]{groupSpec.getGroupName()}), svcErr);
        }
        if (!this.isCurrentUserAdmin()) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotAddGroupNotAdmin", new String[]{groupSpec.getGroupName()}));
        }
        if (this.groupExists(groupSpec.getGroupName())) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotAddGroupExistsError", new String[]{groupSpec.getGroupName()}));
        }
        Vector undefinedUsersList = new Vector();
        if (!this.usersExist(groupSpec.getUsers(), undefinedUsersList)) {
            StringBuffer undefinedUsers = new StringBuffer();
            undefinedUsers.append(undefinedUsersList.elementAt(0));
            for (int i = 1; i < undefinedUsersList.size(); ++i) {
                undefinedUsers.append(", " + undefinedUsersList.elementAt(i));
            }
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotAddGroupUsersUndefinedError", new String[]{groupSpec.getGroupName(), undefinedUsers.toString()}));
        }
        try {
            newGID = this.getNewGID();
        }
        catch (ServiceException svcErr) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotAddGroupGeneral", new String[]{groupSpec.getGroupName()}), svcErr);
        }
        String groupFolder = "/groups/" + groupSpec.getGroupName();
        int exitCode = this.createFolder(groupFolder);
        if (exitCode == 0) {
            try {
                exitCode = this.createProperty(groupFolder, "name", groupSpec.getGroupName());
                if (exitCode == 0) {
                    exitCode = this.createProperty(groupFolder, "gid", newGID);
                }
                if (exitCode == 0) {
                    exitCode = this.createProperty(groupFolder, "passwd", G_DEFAULT_PASSWD);
                }
                if (exitCode == 0 && groupSpec.getUsers().length > 0) {
                    String[] userIds = this.getUserIds(groupSpec.getUsers());
                    exitCode = this.createProperty(groupFolder, G_USERS_PROP, userIds);
                }
            }
            catch (ServiceException svcErr) {
                exitCode = -1;
                throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotAddGroupGeneral", new String[]{groupSpec.getGroupName()}), svcErr);
            }
            finally {
                if (exitCode != 0) {
                    try {
                        this.destroyFolder(groupFolder);
                    }
                    catch (Exception genErr) {}
                }
                try {
                    this.resyncDomain();
                }
                catch (Exception genErr) {}
            }
        }
        if (exitCode != 0) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotAddGroupExitCode", new String[]{groupSpec.getGroupName(), Integer.toString(exitCode)}));
        }
    }

    private String[] getUserIds(UserSpecification[] users) {
        String[] ret = new String[]{};
        if (users != null) {
            ret = new String[users.length];
            for (int i = 0; i < users.length; ++i) {
                ret[i] = users[i].getUserName();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroup(String groupName) throws ServiceException {
        if (groupName != null && groupName.trim().length() != 0) {
            String groupFolder = "/groups/" + groupName;
            if (!this.isCurrentUserAdmin()) {
                throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotDeleteGroupNotAdmin", new String[]{groupName}));
            }
            int exitCode = 0;
            if (this.folderExists(GROUPS_FOLDER, groupName)) {
                String[] userList = this.getUsersFromGroup(groupName);
                if (userList.length == 0) {
                    try {
                        exitCode = this.destroyFolder(groupFolder);
                    }
                    finally {
                        try {
                            this.resyncDomain();
                        }
                        catch (Exception genErr) {}
                    }
                }
                StringBuffer users = new StringBuffer();
                users.append(userList[0]);
                for (int i = 1; i < userList.length; ++i) {
                    users.append(", " + userList[i]);
                }
                throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotDeleteGroupUsersRemain", new String[]{groupName, users.toString()}));
            }
            if (exitCode != 0) {
                throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.cannotDeleteGroupExitCode", new String[]{groupName, Integer.toString(exitCode)}));
            }
        }
    }

    private void verifyNewUserObject(UserSpecification user) throws ServiceException {
        if (user.getUserName() == null || user.getUserName().trim().length() == 0) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.userNameEmptyError"));
        }
        if (user.getUserName().indexOf(" ") >= 0) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.userNameSpaceError"));
        }
        if (user.getUserName().length() > 255) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.userNameTooLongError"));
        }
        if (user.getUserFullName() == null || user.getUserFullName().trim().length() == 0) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.userFullNameEmptyError"));
        }
    }

    private void verifyNewGroupObject(GroupSpecification group) throws ServiceException {
        if (group.getGroupName() == null || group.getGroupName().trim().length() == 0) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.groupNameEmptyError"));
        }
        if (group.getGroupName().indexOf(" ") >= 0) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.groupNameSpaceError"));
        }
        if (group.getGroupName().length() > 255) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.groupNameTooLongError"));
        }
    }

    private boolean userExists(String userName) throws ServiceException {
        return this.folderExists(USERS_FOLDER, userName);
    }

    private boolean usersExist(UserSpecification[] users, Vector missingUsersList) {
        boolean usersExist = true;
        for (int i = 0; i < users.length; ++i) {
            boolean userExists;
            try {
                userExists = this.userExists(users[i].getUserName());
            }
            catch (ServiceException svcErr) {
                userExists = false;
            }
            if (userExists) continue;
            missingUsersList.addElement(users[i]);
            usersExist = false;
        }
        return usersExist;
    }

    private boolean addUserToGroups(String userName, GroupSpecification[] groups, Vector failedGroupsList) {
        boolean groupAddSuccessful = true;
        for (int i = 0; i < groups.length; ++i) {
            int exitCode = 0;
            try {
                String groupFolder = "/groups/" + groups[i].getGroupName();
                exitCode = this.mergeProperty(groupFolder, G_USERS_PROP, userName);
            }
            catch (ServiceException svcErr) {
                exitCode = -1;
            }
            if (exitCode == 0) continue;
            failedGroupsList.addElement(groups[i]);
            groupAddSuccessful = false;
        }
        return groupAddSuccessful;
    }

    private boolean removeUserFromGroups(String userName, String[] groups, Vector failedGroupsList) {
        boolean userRemoveSuccessful = true;
        for (int i = 0; i < groups.length; ++i) {
            int exitCode = 0;
            try {
                String groupFolder = "/groups/" + groups[i];
                exitCode = this.destroyVal(groupFolder, G_USERS_PROP, userName);
            }
            catch (ServiceException svcErr) {
                exitCode = -1;
            }
            if (exitCode == 0) continue;
            failedGroupsList.addElement(groups[i]);
            userRemoveSuccessful = false;
        }
        return userRemoveSuccessful;
    }

    private String[] getUserGroups(String userName) throws ServiceException {
        try {
            Vector<String> groupList = new Vector<String>();
            Hashtable allGroups = this.getSubfolderList(GROUPS_FOLDER);
            Enumeration enumeration = allGroups.keys();
            while (enumeration.hasMoreElements()) {
                String groupName = (String)enumeration.nextElement();
                String groupFolder = "/groups/" + groupName;
                Vector groupUsers = this.getMultiValueProperty(groupFolder, G_USERS_PROP);
                if (groupUsers == null || !groupUsers.contains(userName)) continue;
                groupList.addElement(groupName);
            }
            String[] groups = new String[groupList.size()];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = (String)groupList.elementAt(i);
            }
            return groups;
        }
        catch (ServiceException svcErr) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.getUserGroupsError", new String[]{userName}), svcErr);
        }
    }

    private String[] getUsersFromGroup(String groupName) throws ServiceException {
        try {
            String groupFolder = "/groups/" + groupName;
            Vector usersList = this.getMultiValueProperty(groupFolder, G_USERS_PROP);
            int userCount = usersList == null ? 0 : usersList.size();
            String[] users = new String[userCount];
            for (int i = 0; i < userCount; ++i) {
                users[i] = (String)usersList.elementAt(i);
            }
            return users;
        }
        catch (ServiceException svcErr) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.getGroupUsersError", new String[]{groupName}), svcErr);
        }
    }

    private boolean groupExists(String groupName) throws ServiceException {
        return this.folderExists(GROUPS_FOLDER, groupName);
    }

    private boolean groupsExist(GroupSpecification[] groups, Vector missingGroupsList) {
        boolean groupsExist = true;
        for (int i = 0; i < groups.length; ++i) {
            boolean groupExists;
            try {
                groupExists = this.groupExists(groups[i].getGroupName());
            }
            catch (ServiceException svcErr) {
                groupExists = false;
            }
            if (groupExists) continue;
            missingGroupsList.addElement(groups[i]);
            groupsExist = false;
        }
        return groupsExist;
    }

    private boolean userFullNameExists(String userFullName) throws ServiceException {
        int exitCode;
        try {
            String[] args = new String[]{DEFAULT_DOMAIN, USERS_FOLDER, U_FULL_NAME_PROP};
            CommandResult info = CommandUtils.executeCommand(NIREPORT_CMD, args);
            String fullNameList = info.getStdout();
            exitCode = info.getExitCode();
            if (exitCode == 0) {
                StringTokenizer tok = new StringTokenizer(fullNameList, System.getProperty("line.separator"));
                Hashtable<String, String> usedFullNames = new Hashtable<String, String>();
                while (tok.hasMoreTokens()) {
                    usedFullNames.put(tok.nextToken().trim(), "");
                }
                return usedFullNames.containsKey(userFullName);
            }
        }
        catch (ServiceException svcErr) {
            throw svcErr;
        }
        catch (Exception genErr) {
            throw new ServiceException(genErr);
        }
        throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.fullNameCheckGeneralError", new String[]{userFullName, Integer.toString(exitCode)}));
    }

    private String getNewUID() throws ServiceException {
        int exitCode;
        try {
            String[] args = new String[]{DEFAULT_DOMAIN, USERS_FOLDER, U_UID_PROP};
            CommandResult info = CommandUtils.executeCommand(NIREPORT_CMD, args);
            String uidList = info.getStdout();
            exitCode = info.getExitCode();
            if (exitCode == 0) {
                StringTokenizer tok = new StringTokenizer(uidList, System.getProperty("line.separator"));
                Hashtable<String, String> uids = new Hashtable<String, String>();
                while (tok.hasMoreTokens()) {
                    uids.put(tok.nextToken().trim(), "");
                }
                int newUID = 501;
                while (uids.containsKey(Integer.toString(newUID))) {
                    ++newUID;
                }
                return Integer.toString(newUID);
            }
        }
        catch (ServiceException svcErr) {
            throw svcErr;
        }
        catch (Exception genErr) {
            throw new ServiceException(genErr);
        }
        throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.newUserIdGeneralError", new String[]{Integer.toString(exitCode)}));
    }

    private String getNewGID() throws ServiceException {
        int exitCode;
        try {
            String[] args = new String[]{DEFAULT_DOMAIN, GROUPS_FOLDER, "gid"};
            CommandResult info = CommandUtils.executeCommand(NIREPORT_CMD, args);
            String gidList = info.getStdout();
            exitCode = info.getExitCode();
            if (exitCode == 0) {
                StringTokenizer tok = new StringTokenizer(gidList, System.getProperty("line.separator"));
                Hashtable<String, String> gids = new Hashtable<String, String>();
                while (tok.hasMoreTokens()) {
                    gids.put(tok.nextToken().trim(), "");
                }
                int newGID = 501;
                while (gids.containsKey(Integer.toString(newGID))) {
                    ++newGID;
                }
                return Integer.toString(newGID);
            }
        }
        catch (ServiceException svcErr) {
            throw svcErr;
        }
        catch (Exception genErr) {
            throw new ServiceException(genErr);
        }
        throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.newGroupIdGeneralError", new String[]{Integer.toString(exitCode)}));
    }

    private String getUserDefaultGID(GroupSpecification[] groups) {
        String gid = G_NO_GROUP_GID;
        boolean gidFound = false;
        for (int i = 0; !gidFound && i < groups.length; ++i) {
            try {
                String groupGID;
                String groupFolder = "/groups/" + groups[i];
                if (!this.folderExists(GROUPS_FOLDER, groups[i].getGroupName()) || (groupGID = this.getProperty(groupFolder, "gid")) == null) continue;
                gid = groupGID;
                gidFound = true;
                continue;
            }
            catch (ServiceException svcErr) {
                // empty catch block
            }
        }
        return gid;
    }

    private String encryptPassword(String password) throws ServiceException {
        int exitCode;
        try {
            String[] args = new String[]{"passwd", password};
            CommandResult info = CommandUtils.executeCommand("openssl", args);
            String encryptedPassword = info.getStdout();
            exitCode = info.getExitCode();
            if (exitCode == 0) {
                StringTokenizer tok = new StringTokenizer(encryptedPassword, System.getProperty("line.separator"));
                return tok.nextToken().trim();
            }
        }
        catch (ServiceException svcErr) {
            throw svcErr;
        }
        catch (Exception genErr) {
            throw new ServiceException(genErr);
        }
        throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.passwordEncryptionGeneralError", new String[]{Integer.toString(exitCode)}));
    }

    private int createFolder(String folderName) throws ServiceException {
        try {
            String[] args = new String[]{CREATE_FOLDER, DEFAULT_DOMAIN, folderName};
            return CommandUtils.executeCommand(NIUTIL_CMD, args).getExitCode();
        }
        catch (Exception genErr) {
            throw new ServiceException(genErr);
        }
    }

    private Hashtable getSubfolderList(String parentFolderName) throws ServiceException {
        int exitCode;
        try {
            String[] args = new String[]{DEFAULT_DOMAIN, parentFolderName, "name"};
            CommandResult info = CommandUtils.executeCommand(NIREPORT_CMD, args);
            String folderList = info.getStdout();
            exitCode = info.getExitCode();
            if (exitCode == 0) {
                StringTokenizer tok = new StringTokenizer(folderList, System.getProperty("line.separator"));
                Hashtable<String, String> folderNames = new Hashtable<String, String>();
                while (tok.hasMoreTokens()) {
                    folderNames.put(tok.nextToken().trim(), "");
                }
                return folderNames;
            }
        }
        catch (ServiceException svcErr) {
            throw svcErr;
        }
        catch (Exception genErr) {
            throw new ServiceException(genErr);
        }
        throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.folderListGeneralError", new String[]{parentFolderName, Integer.toString(exitCode)}));
    }

    private boolean folderExists(String parentFolderName, String folderName) throws ServiceException {
        try {
            Hashtable subFolderList = this.getSubfolderList(parentFolderName);
            return subFolderList.containsKey(folderName);
        }
        catch (ServiceException svcErr) {
            String fullFolderName = parentFolderName + DEFAULT_DOMAIN + folderName;
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "MacOSXSecurityServiceImpl.folderExistsGeneralError", new String[]{fullFolderName}), svcErr);
        }
    }

    private int destroyFolder(String folderName) throws ServiceException {
        try {
            String[] args = new String[]{DESTROY_FOLDER, DEFAULT_DOMAIN, folderName};
            return CommandUtils.executeCommand(NIUTIL_CMD, args).getExitCode();
        }
        catch (Exception genErr) {
            throw new ServiceException(genErr);
        }
    }

    private int createProperty(String folderName, String propertyName, String propertyValue) throws ServiceException {
        try {
            String[] args = new String[]{CREATE_PROP, DEFAULT_DOMAIN, folderName, propertyName, propertyValue};
            return CommandUtils.executeCommand(NIUTIL_CMD, args).getExitCode();
        }
        catch (Exception genErr) {
            throw new ServiceException(genErr);
        }
    }

    private int createProperty(String folderName, String propertyName, String[] propertyValues) throws ServiceException {
        try {
            String[] args = new String[4 + propertyValues.length];
            args[0] = CREATE_PROP;
            args[1] = DEFAULT_DOMAIN;
            args[2] = folderName;
            args[3] = propertyName;
            for (int i = 0; i < propertyValues.length; ++i) {
                args[4 + i] = propertyValues[i];
            }
            return CommandUtils.executeCommand(NIUTIL_CMD, args).getExitCode();
        }
        catch (Exception genErr) {
            throw new ServiceException(genErr);
        }
    }

    private int mergeProperty(String folderName, String propertyName, String propertyValue) throws ServiceException {
        try {
            String[] args = new String[]{MERGE_PROP, DEFAULT_DOMAIN, folderName, propertyName, propertyValue};
            return CommandUtils.executeCommand(NIUTIL_CMD, args).getExitCode();
        }
        catch (Exception genErr) {
            throw new ServiceException(genErr);
        }
    }

    private int destroyVal(String folderName, String propertyName, String propertyValue) throws ServiceException {
        try {
            String[] args = new String[]{DESTROY_VAL, DEFAULT_DOMAIN, folderName, propertyName, propertyValue};
            return CommandUtils.executeCommand(NIUTIL_CMD, args).getExitCode();
        }
        catch (Exception genErr) {
            throw new ServiceException(genErr);
        }
    }

    private String getProperty(String folderName, String propertyName) throws ServiceException {
        try {
            StringTokenizer tok;
            String propertyValue = null;
            String[] args = new String[]{READ_PROP, DEFAULT_DOMAIN, folderName, propertyName};
            CommandResult info = CommandUtils.executeCommand(NIUTIL_CMD, args);
            String propertyList = info.getStdout();
            int exitCode = info.getExitCode();
            if (exitCode == 0 && (tok = new StringTokenizer(propertyList, System.getProperty("line.separator"))).hasMoreTokens()) {
                propertyValue = tok.nextToken();
            }
            return propertyValue;
        }
        catch (ServiceException svcErr) {
            throw svcErr;
        }
        catch (Exception genErr) {
            throw new ServiceException(genErr);
        }
    }

    private Vector getMultiValueProperty(String folderName, String propertyName) throws ServiceException {
        Vector<String> propertyValue = null;
        String propertyList = this.getProperty(folderName, propertyName);
        if (propertyList != null) {
            propertyValue = new Vector<String>();
            StringTokenizer tok = new StringTokenizer(propertyList, " ");
            while (tok.hasMoreTokens()) {
                propertyValue.addElement(tok.nextToken().trim());
            }
        }
        return propertyValue;
    }

    private int resyncDomain() throws Exception {
        String[] args = new String[]{RESYNC_DOMAIN, DEFAULT_DOMAIN};
        return CommandUtils.executeCommand(NIUTIL_CMD, args).getExitCode();
    }
}

