/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.macosx.service.system;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.macosx.MacOSXUtils;
import com.installshield.wizard.platform.macosx.utils.Environment;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.PureJavaSystemUtilServiceImpl;
import com.installshield.wizard.service.system.SystemUtilService;

public class MacOSXSystemUtilServiceImpl
extends PureJavaSystemUtilServiceImpl {
    public int getSystemCompatibility() {
        return MacOSXUtils.getSystemCompatibility();
    }

    protected void initialized() {
        super.initialized();
        try {
            MacOSXUtils.loadLibrary(this.getServiceResource(MacOSXUtils.getJNILibraryResourceName()), MacOSXUtils.getJNILibraryName());
        }
        catch (Exception ex) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.macosx.i18n.MacOSXResources", "serviceCannotLoadJniLibrary", new String[]{SystemUtilService.NAME, MacOSXUtils.getJNILibraryName()}));
            ex.printStackTrace();
        }
    }

    public String getEnvironmentVariable(String variableName) throws ServiceException {
        return Environment.getProcessEnvironmentVariable(variableName);
    }
}

