/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.solaris;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.CommandUtils;
import com.installshield.util.FileAttributes;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.common.util.GenericUnixCommands;
import com.installshield.wizard.platform.common.util.GenericUnixFileAttributes;
import com.installshield.wizard.platform.solaris.util.LibraryLoader;
import com.installshield.wizard.platform.solaris.util.MountedFileSystemTable;
import com.installshield.wizard.platform.solaris.util.SystemCompatability;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.PureJavaFileServiceImpl;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class SolarisFileServiceImpl
extends PureJavaFileServiceImpl {
    private String mnttabname = File.separator + "etc" + File.separator + "mnttab";
    private MountedFileSystemTable mnttab = null;
    private Vector readableDeferredList;

    private native void chown(String var1, String var2, String var3) throws ServiceException;

    public void cleanup() throws ServiceException {
        if (this.readableDeferredList != null) {
            Enumeration e = this.readableDeferredList.elements();
            while (e.hasMoreElements()) {
                String filename = (String)e.nextElement();
                FileAttributes attrib = this.getFileAttributes(filename);
                attrib.setAttributeState(73, true);
                this.setFileAttributes(filename, attrib);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public int deleteDirectory(String directory, boolean ifEmpty, boolean includeSubDirs) throws ServiceException {
        returnValue = 0;
        error = false;
        errorMessage = "";
        dirName = this.createFileName(this.getCurrentDirectory(), directory);
        if (this.fileExists(dirName) && this.isDirectory(dirName) && this.getParent(dirName) == null) {
            throw new ServiceException(305, "deleteDirectory cannot be used to delete the root directory");
        }
        if (this.isDirectory(dirName)) {
            if (!ifEmpty && !includeSubDirs) {
                try {
                    dirCmdString = CoreFileUtils.appendSeparator(dirName, this.getSeparator()) + "*";
                    info = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -f \"" + dirCmdString + "\""});
                    if (info.getExitCode() == 0) {
                        info = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir \"" + dirName + "\""});
                        if (info.getExitCode() == 0) ** GOTO lbl42
                        error = true;
                        errorMessage = info.getStderr();
                    }
                    error = true;
                    errorMessage = info.getStderr();
                }
                catch (Exception genErr) {
                    throw new ServiceException(genErr);
                }
            } else if (ifEmpty && !includeSubDirs) {
                try {
                    info = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir \"" + dirName + "\""});
                    if (info.getExitCode() == 0) ** GOTO lbl42
                    error = true;
                    errorMessage = info.getStderr();
                }
                catch (Exception genErr) {
                    throw new ServiceException(genErr);
                }
            } else if (!ifEmpty && includeSubDirs) {
                try {
                    info = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -rf \"" + dirName + "\""});
                    if (info.getExitCode() == 0) ** GOTO lbl42
                    error = true;
                    errorMessage = info.getStderr();
                }
                catch (Exception genErr) {
                    throw new ServiceException(genErr);
                }
            } else {
                returnValue = super.deleteDirectory(directory, ifEmpty, includeSubDirs);
            }
        }
lbl42:
        // 10 sources

        if (error) {
            throw new ServiceException(2, "Error deleting directory: " + errorMessage);
        }
        return returnValue;
    }

    public FileAttributes getFileAttributes(String file) throws ServiceException {
        return GenericUnixFileAttributes.getAttributeObject(file, this.getFileMode(file));
    }

    private native int getFileMode(String var1) throws ServiceException;

    public native String getFileOwner(String var1) throws ServiceException;

    public native String getFileOwnerGroup(String var1) throws ServiceException;

    protected String getLibraryDirectory() throws ServiceException {
        return File.separator + "usr" + File.separator + "lib";
    }

    private MountedFileSystemTable getMnttab() throws ServiceException {
        if (this.mnttab == null) {
            this.mnttab = new MountedFileSystemTable();
            this.mnttab.setFilename(this.mnttabname);
            try {
                this.mnttab.load();
            }
            catch (IOException e) {
                throw new ServiceException(e);
            }
        }
        return this.mnttab;
    }

    public String getPartitionFormat(String partition) throws ServiceException {
        int i = 0;
        try {
            while (!this.mnttab.getMountPoint(i).equals(partition)) {
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ServiceException(314, LocalizedStringResolver.resolve("com.installshield.wizard.platform.solaris.i18n.SolarisResources", "solaris.ppk.invalid.parameter", new String[]{partition}));
        }
        String fs = this.mnttab.getFstype(i);
        return fs;
    }

    public native long getPartitionFreeSpace(String var1) throws ServiceException;

    public String[] getPartitionNames() throws ServiceException {
        return this.getMnttab().getMountPoint();
    }

    public int getPartitionType(String partition) throws ServiceException {
        return !(partition = partition.trim()).startsWith("/dev/") || !partition.substring(5).endsWith("cd") && !partition.substring(5).endsWith("fd") && !partition.substring(5).endsWith("rmt") ? 1 : 2;
    }

    protected String getStandardInstallDirectory() throws ServiceException {
        return File.separator + "opt";
    }

    public int getSystemCompatibility() {
        return SystemCompatability.getScore();
    }

    protected String getTempDirectory() throws ServiceException {
        return File.separator + "tmp";
    }

    protected void initialized() {
        super.initialized();
        LibraryLoader.loadLibrary(this.getServices());
    }

    public boolean isPartitionWritable(String partition) throws ServiceException {
        int i = 0;
        try {
            while (!this.mnttab.getMountPoint(i).equals(partition)) {
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ServiceException(314, LocalizedStringResolver.resolve("com.installshield.wizard.platform.solaris.i18n.SolarisResources", "solaris.ppk.invalid.parameter", new String[]{partition}));
        }
        String[] options = this.mnttab.getOptions(i);
        boolean result = false;
        for (int j = 0; j < options.length; ++j) {
            if (!options[j].equals("rw")) continue;
            result = true;
            break;
        }
        return result;
    }

    public void setFileAttributes(String file, FileAttributes attributes) throws ServiceException {
        this.setFileMode(file, GenericUnixFileAttributes.getMode(attributes));
    }

    public void setFileCreated(String fileName, long date) throws ServiceException {
        this.setFileModified(fileName, date);
    }

    public void setFileExecutable(String file) throws ServiceException {
        FileAttributes attribs = this.getFileAttributes(file);
        int attribMask = 292;
        attribs.setAttributeState(attribMask, true);
        this.setFileMode(file, GenericUnixFileAttributes.getMode(attribs));
    }

    private native void setFileMode(String var1, int var2) throws ServiceException;

    public native void setFileModified(String var1, long var2) throws ServiceException;

    public void setFileOwner(String file, String userid) throws ServiceException {
        this.chown(file, userid, null);
    }

    public void setFileOwnerGroup(String file, String groupid) throws ServiceException {
        this.chown(file, null, groupid);
    }

    public native void setFileTimes(String var1, long var2, long var4, long var6) throws ServiceException;

    public boolean supportsLongFileNames(String partition) throws ServiceException {
        return true;
    }

    public void validateFileName(String fileName) throws ServiceException {
        String invalidChars = ":*?\"<>|^!";
        for (int i = 0; i < fileName.length(); ++i) {
            if (invalidChars.indexOf(fileName.charAt(i)) == -1) continue;
            throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "FileServiceImpl.invalidCharacters", new String[]{invalidChars}));
        }
    }

    public native void setSystemUMask(int var1) throws ServiceException;

    public native int getSystemUMask() throws ServiceException;

    void addToDeferredList(String file) {
        if (this.readableDeferredList == null) {
            this.readableDeferredList = new Vector();
        }
        this.readableDeferredList.addElement(file);
    }

    void removeFromDeferredList(String file) {
        if (this.readableDeferredList != null && this.readableDeferredList.size() > 0) {
            this.readableDeferredList.removeElement(file);
        }
    }

    public void createSymbolicLink(String target, String linkName, boolean forceLink) throws ServiceException {
        GenericUnixCommands.createSymbolicLink(target, linkName, forceLink);
    }

    public void removeSymbolicLink(String linkName) throws ServiceException {
        GenericUnixCommands.removeSymbolicLink(linkName);
    }
}

