/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.solaris;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.common.util.GenericUnixCommands;
import com.installshield.wizard.platform.common.util.UnixCrypt;
import com.installshield.wizard.platform.solaris.util.SystemCompatability;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.security.GroupSpecification;
import com.installshield.wizard.service.security.PureJavaSecurityServiceImpl;
import com.installshield.wizard.service.security.SecurityServiceImplementor;
import com.installshield.wizard.service.security.UserSpecification;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class SolarisSecurityServiceImpl
extends PureJavaSecurityServiceImpl
implements SecurityServiceImplementor {
    public boolean canCurrentUserWrite(String filename) throws ServiceException {
        return new File(filename).canWrite();
    }

    public void createUser(UserSpecification user) throws ServiceException {
        GenericUnixCommands.createUser(user);
        String password = user.getPassword();
        if (password != null) {
            String shadowFilePath = "/etc/shadow";
            String passwdFilePath = "/etc/passwd";
            String backupShadowFilePath = "/etc/shadow.backup";
            String backupPasswdFilePath = "/etc/passwd.backup";
            File shadowFile = new File(shadowFilePath);
            String userName = user.getUserName();
            String encPassword = UnixCrypt.crypt(UnixCrypt.getRandomSalt(), password);
            try {
                if (shadowFile.exists() && this.userExists(shadowFilePath, userName)) {
                    this.copyFile(shadowFilePath, backupShadowFilePath);
                    String tempShadow = CoreFileUtils.createTempFile();
                    try {
                        this.updateTempFile(userName, encPassword, tempShadow, shadowFilePath);
                        this.copyFile(tempShadow, shadowFilePath);
                    }
                    catch (Exception e) {
                        this.copyFile(backupShadowFilePath, shadowFilePath);
                    }
                } else if (this.userExists(passwdFilePath, userName)) {
                    this.copyFile(passwdFilePath, backupPasswdFilePath);
                    String tempPasswd = CoreFileUtils.createTempFile();
                    try {
                        this.updateTempFile(userName, encPassword, tempPasswd, passwdFilePath);
                        this.copyFile(tempPasswd, passwdFilePath);
                    }
                    catch (Exception e) {
                        this.copyFile(backupPasswdFilePath, passwdFilePath);
                    }
                }
            }
            catch (IOException e) {
                throw new ServiceException(e);
            }
        }
    }

    private String updateUserPassword(String str, String pass) {
        StringBuffer line = new StringBuffer();
        StringTokenizer st = new StringTokenizer(str, ":", true);
        int ctr = 0;
        int passwordIdx = 2;
        while (st.hasMoreTokens()) {
            String thisToken = st.nextToken();
            if (ctr == passwordIdx) {
                line.append(pass);
            } else {
                line.append(thisToken);
            }
            ++ctr;
        }
        return line.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String file1, String file2) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(new File(file1));
            out = new FileOutputStream(new File(file2));
            CoreFileUtils.copy(in, out);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception genErr) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception genErr) {}
        }
    }

    private void updateTempFile(String user, String pass, String tempFile, String sourceFile) throws Exception {
        BufferedReader reader = null;
        FileOutputStream out = null;
        PrintWriter writer = null;
        reader = new BufferedReader(new InputStreamReader(new FileInputStream(sourceFile)));
        out = new FileOutputStream(tempFile);
        writer = new PrintWriter(out);
        String line = reader.readLine();
        while (line != null) {
            StringTokenizer st = new StringTokenizer(line.trim(), ":");
            String username = st.nextToken();
            String output = "";
            output = username != null && username.trim().equals(user) ? this.updateUserPassword(line, pass) : line;
            writer.println(output);
            line = reader.readLine();
        }
        reader.close();
        writer.flush();
        writer.close();
        writer = null;
    }

    private boolean userExists(String filepath, String user) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(filepath)));
            String line = reader.readLine();
            while (line != null) {
                StringTokenizer st = new StringTokenizer(line.trim(), ":");
                String username = st.nextToken();
                if (username != null && username.trim().equals(user)) {
                    return true;
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void deleteUser(String username) throws ServiceException {
        try {
            Process p = Runtime.getRuntime().exec("/usr/sbin/userdel " + username);
            int status = p.waitFor();
            if (status != 0) {
                throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.solaris.i18n.SolarisResources", "security.deleteUserError", new String[]{Integer.toString(status)}));
            }
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        catch (InterruptedException e) {
            throw new ServiceException(e);
        }
    }

    public int getSystemCompatibility() {
        return SystemCompatability.getScore();
    }

    public boolean isCurrentUserAdmin() throws ServiceException {
        return System.getProperty("user.name").equals("root");
    }

    public void createGroup(GroupSpecification groupSpec) throws ServiceException {
        try {
            Process p = Runtime.getRuntime().exec("/usr/sbin/groupadd " + groupSpec.getGroupName());
            int status = p.waitFor();
            switch (status) {
                case 0: 
                case 9: {
                    break;
                }
                default: {
                    throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.solaris.i18n.SolarisResources", "security.createGroupError", new String[]{Integer.toString(status)}));
                }
            }
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        catch (InterruptedException e) {
            throw new ServiceException(e);
        }
    }

    public void deleteGroup(String groupid) throws ServiceException {
        try {
            Process p = Runtime.getRuntime().exec("/usr/sbin/groupdel " + groupid);
            int status = p.waitFor();
            switch (status) {
                case 0: 
                case 6: {
                    break;
                }
                default: {
                    throw new ServiceException(2, LocalizedStringResolver.resolve("com.installshield.wizard.platform.solaris.i18n.SolarisResources", "security.deleteGroupError", new String[]{Integer.toString(status)}));
                }
            }
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        catch (InterruptedException e) {
            throw new ServiceException(e);
        }
    }
}

