/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.solaris.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class MountedFileSystemTable {
    private String filename = File.separator + "etc" + File.separator + "mnttab";
    private String[] special = null;
    private String[] mountPoint = null;
    private String[] fstype = null;
    private String[][] options = null;
    private String[] time = null;

    public String getFilename() {
        return this.filename;
    }

    public String[] getFstype() {
        return this.fstype;
    }

    public String getFstype(int index) {
        return this.fstype[index];
    }

    public String[] getMountPoint() {
        return this.mountPoint;
    }

    public String getMountPoint(int index) {
        return this.mountPoint[index];
    }

    public String[][] getOptions() {
        return this.options;
    }

    public String[] getOptions(int index) {
        return this.options[index];
    }

    public String[] getSpecial() {
        return this.special;
    }

    public String getSpecial(int index) {
        return this.special[index];
    }

    public String[] getTime() {
        return this.time;
    }

    public String getTime(int index) {
        return this.time[index];
    }

    public void load() throws IOException {
        Vector<String> mntSpecial = new Vector<String>();
        Vector<String> mntMountPoint = new Vector<String>();
        Vector<String> mntFSType = new Vector<String>();
        Vector<String[]> mntOptions = new Vector<String[]>();
        Vector<String> mntTime = new Vector<String>();
        BufferedReader in = new BufferedReader(new FileReader(this.getFilename()));
        String line = in.readLine();
        while (line != null) {
            if ((line = line.trim()).length() > 0 & line.charAt(0) != '#') {
                StringTokenizer lineTokens = new StringTokenizer(line);
                mntSpecial.addElement(lineTokens.nextToken());
                mntMountPoint.addElement(lineTokens.nextToken());
                mntFSType.addElement(lineTokens.nextToken());
                String optionStr = lineTokens.nextToken();
                StringTokenizer optionTokens = new StringTokenizer(optionStr, ",");
                String[] options = new String[optionTokens.countTokens()];
                for (int i = 0; i < options.length; ++i) {
                    options[i] = optionTokens.nextToken();
                }
                mntOptions.addElement(options);
                mntTime.addElement(lineTokens.nextToken());
            }
            line = in.readLine();
        }
        int partitionCount = mntSpecial.size();
        this.special = new String[partitionCount];
        this.mountPoint = new String[partitionCount];
        this.fstype = new String[partitionCount];
        this.options = new String[partitionCount][];
        this.time = new String[partitionCount];
        mntSpecial.copyInto(this.special);
        mntMountPoint.copyInto(this.mountPoint);
        mntFSType.copyInto(this.fstype);
        mntOptions.copyInto((Object[])this.options);
        mntTime.copyInto(this.time);
    }

    public void setFilename(String newFilename) {
        this.filename = newFilename;
    }
}

