/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.solaris.util;

import java.util.Enumeration;
import java.util.Vector;

public class SystemCompatability {
    private static int score = -1;
    private static Vector osName = new Vector();
    private static Vector osArchSparc = new Vector();
    private static Vector osArchx86 = new Vector();

    private SystemCompatability() {
    }

    public static int getScore() {
        if (score == -1) {
            score = SystemCompatability.isSystemCompatible(osArchSparc) || SystemCompatability.isSystemCompatible(osArchx86) ? 5 : 0;
        }
        return score;
    }

    private static boolean isSystemCompatible(Vector osArch) {
        return !(!SystemCompatability.isPresent(System.getProperty("os.name").toLowerCase(), osName.elements()) || !SystemCompatability.isPresent(System.getProperty("os.arch").toLowerCase(), osArch.elements()) || !System.getProperty("os.version").equals("2.x") && Double.valueOf(System.getProperty("os.version")) < 2.6);
    }

    private static boolean isPresent(String tag, Enumeration list) {
        boolean present = false;
        String ss = null;
        while (list.hasMoreElements()) {
            ss = (String)list.nextElement();
            if (!tag.regionMatches(true, 0, ss, 0, ss.length())) continue;
            present = true;
            break;
        }
        return present;
    }

    public static boolean isSparcSystem() {
        return SystemCompatability.isSystemCompatible(osArchSparc);
    }

    public static boolean isX86System() {
        return SystemCompatability.isSystemCompatible(osArchx86);
    }

    public static int getSolarisSparcCompatibilityScore() {
        return SystemCompatability.isSparcSystem() ? 5 : 0;
    }

    public static int getSolarisx86CompatibilityScore() {
        return SystemCompatability.isX86System() ? 5 : 0;
    }

    public static void main(String[] args) {
        System.out.println(SystemCompatability.getScore());
    }

    static {
        osName.addElement("solaris");
        osName.addElement("sunos");
        osArchSparc.addElement("sparc");
        osArchx86.addElement("x86");
    }
}

