/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.solaris.util;

import com.installshield.util.FileAttributes;

public class UnixAttributes {
    private static int S_ISUID = 2048;
    private static int S_ISGID = 1024;
    private static int S_ISVTX = 512;
    private static int S_IRWXU = 448;
    private static int S_IRUSR = 256;
    private static int S_IWUSR = 128;
    private static int S_IXUSR = 64;
    private static int S_IRWXG = 56;
    private static int S_IRGRP = 32;
    private static int S_IWGRP = 16;
    private static int S_IXGRP = 8;
    private static int S_IRWXO = 7;
    private static int S_IROTH = 4;
    private static int S_IWOTH = 2;
    private static int S_IXOTH = 1;

    public static FileAttributes getAttributeObject(int mode) {
        FileAttributes attributes = new FileAttributes();
        if ((mode & S_IRUSR) == S_IRUSR) {
            attributes.setAttributeState(1, true);
        }
        if ((mode & S_IRGRP) == S_IRGRP) {
            attributes.setAttributeState(8, true);
        }
        if ((mode & S_IROTH) == S_IROTH) {
            attributes.setAttributeState(64, true);
        }
        if ((mode & S_IWUSR) == S_IWUSR) {
            attributes.setAttributeState(2, true);
        }
        if ((mode & S_IWGRP) == S_IWGRP) {
            attributes.setAttributeState(16, true);
        }
        if ((mode & S_IWOTH) == S_IWOTH) {
            attributes.setAttributeState(128, true);
        }
        if ((mode & S_IXUSR) == S_IXUSR) {
            attributes.setAttributeState(4, true);
        }
        if ((mode & S_IXGRP) == S_IXGRP) {
            attributes.setAttributeState(32, true);
        }
        if ((mode & S_IXOTH) == S_IXOTH) {
            attributes.setAttributeState(256, true);
        }
        return attributes;
    }

    public static FileAttributes getAttributeObject(String filename, int mode) {
        FileAttributes attributes = UnixAttributes.getAttributeObject(mode);
        if (filename.charAt(0) == '.') {
            attributes.setAttributeState(512, true);
        }
        return attributes;
    }

    public static String getAttributeString(int mode) {
        StringBuffer attributes = new StringBuffer();
        if ((mode & S_IRUSR) == S_IRUSR) {
            attributes.append("rU");
        }
        if ((mode & S_IRGRP) == S_IRGRP) {
            attributes.append("rG");
        }
        if ((mode & S_IROTH) == S_IROTH) {
            attributes.append("rO");
        }
        if ((mode & S_IWUSR) == S_IWUSR) {
            attributes.append("wU");
        }
        if ((mode & S_IWGRP) == S_IWGRP) {
            attributes.append("wG");
        }
        if ((mode & S_IWOTH) == S_IWOTH) {
            attributes.append("wO");
        }
        if ((mode & S_IXUSR) == S_IXUSR) {
            attributes.append("xU");
        }
        if ((mode & S_IXGRP) == S_IXGRP) {
            attributes.append("xG");
        }
        if ((mode & S_IXOTH) == S_IXOTH) {
            attributes.append("xO");
        }
        if ((mode & S_ISUID) == S_ISUID) {
            attributes.append("s");
        }
        if ((mode & S_ISGID) == S_ISGID) {
            attributes.append("g");
        }
        return attributes.toString();
    }

    public static int getMode(FileAttributes attributes) {
        int mode = 0;
        if (attributes.getAttributeState(1)) {
            mode |= S_IRUSR;
        }
        if (attributes.getAttributeState(8)) {
            mode |= S_IRGRP;
        }
        if (attributes.getAttributeState(64)) {
            mode |= S_IROTH;
        }
        if (attributes.getAttributeState(2)) {
            mode |= S_IWUSR;
        }
        if (attributes.getAttributeState(16)) {
            mode |= S_IWGRP;
        }
        if (attributes.getAttributeState(128)) {
            mode |= S_IWOTH;
        }
        if (attributes.getAttributeState(4)) {
            mode |= S_IXUSR;
        }
        if (attributes.getAttributeState(32)) {
            mode |= S_IXGRP;
        }
        if (attributes.getAttributeState(256)) {
            mode |= S_IXOTH;
        }
        return mode;
    }

    public static int getMode(String attributes) {
        int mode = 0;
        if (attributes.indexOf("rU") != -1) {
            mode |= S_IRUSR;
        }
        if (attributes.indexOf("rG") != -1) {
            mode |= S_IRGRP;
        }
        if (attributes.indexOf("rO") != -1) {
            mode |= S_IROTH;
        }
        if (attributes.indexOf("wU") != -1) {
            mode |= S_IWUSR;
        }
        if (attributes.indexOf("wG") != -1) {
            mode |= S_IWGRP;
        }
        if (attributes.indexOf("wO") != -1) {
            mode |= S_IWOTH;
        }
        if (attributes.indexOf("xU") != -1) {
            mode |= S_IXUSR;
        }
        if (attributes.indexOf("xG") != -1) {
            mode |= S_IXGRP;
        }
        if (attributes.indexOf("xO") != -1) {
            mode |= S_IXOTH;
        }
        if (attributes.indexOf("s") != -1) {
            mode |= S_ISUID;
        }
        if (attributes.indexOf("g") != -1) {
            mode |= S_ISGID;
        }
        return mode;
    }
}

