/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.FileAttributes;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.win32.Win32Platform;
import com.installshield.wizard.platform.win32.Win32Utils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.file.FileServiceImplementor;
import com.installshield.wizard.service.file.PureJavaFileServiceImpl;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.File;
import java.util.GregorianCalendar;

public class Win32FileServiceImpl
extends PureJavaFileServiceImpl
implements FileServiceImplementor {
    public static final String PLATFORM_ID = "win32ppk";
    public static final String OS_MAIN_DIR = "os_main";
    public static final String OS_VOLUME_DIR = "os_volume";
    public static final String COMMON_DIR = "common";
    static final String IS_VPD_DIR = "is_vpd_dir";

    public int getSystemCompatibility() {
        int result = 0;
        try {
            if (Win32Platform.isCompatibleWith(1, 1)) {
                result = 5;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    protected void initialized() {
        super.initialized();
        try {
            Win32Utils.loadDLL(this.getServiceResource(Win32Utils.getJNIDLLResourceName()), Win32Utils.getJNIDLLName());
        }
        catch (Exception ex) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "serviceCannotLoadJniDll", new String[]{FileService.NAME, Win32Utils.getJNIDLLName()}));
            ex.printStackTrace();
        }
    }

    public void setFileTimes(String fileName, long creationDate, long accessDate, long writeDate) throws ServiceException {
        creationDate = this.normalizeDate(creationDate);
        accessDate = this.normalizeDate(accessDate);
        writeDate = this.normalizeDate(writeDate);
        this.win32SetFileTimes(fileName, creationDate, accessDate, writeDate);
    }

    private native void win32SetFileTimes(String var1, long var2, long var4, long var6) throws ServiceException;

    public void setFileCreated(String fileName, long date) throws ServiceException {
        date = this.normalizeDate(date);
        this.win32SetFileCreated(fileName, date);
    }

    private native void win32SetFileCreated(String var1, long var2) throws ServiceException;

    public void setFileModified(String fileName, long date) throws ServiceException {
        date = this.normalizeDate(date);
        this.win32SetFileModified(fileName, date);
    }

    private native void win32SetFileModified(String var1, long var2) throws ServiceException;

    public int copyFile(String sourceFileName, String destinationFileName, boolean overwrite) throws ServiceException {
        SystemUtilService svc;
        int result = this.win32CopyFile(sourceFileName, destinationFileName, overwrite);
        if (result == 1 && (svc = (SystemUtilService)this.getServices().getService(SystemUtilService.NAME)) != null) {
            svc.setRebootRequired(true);
        }
        return result;
    }

    private native int win32CopyFile(String var1, String var2, boolean var3) throws ServiceException;

    public int moveFile(String sourceFileName, String destFileName, boolean overwrite) throws ServiceException {
        SystemUtilService svc;
        int result = this.win32MoveFile(sourceFileName, destFileName, overwrite);
        if (result == 1 && (svc = (SystemUtilService)this.getServices().getService(SystemUtilService.NAME)) != null) {
            svc.setRebootRequired(true);
        }
        return result;
    }

    private native int win32MoveFile(String var1, String var2, boolean var3) throws ServiceException;

    public int deleteFile(String fileName) throws ServiceException {
        SystemUtilService svc;
        int result = this.win32DeleteFile(fileName);
        if (result == 1 && (svc = (SystemUtilService)this.getServices().getService(SystemUtilService.NAME)) != null) {
            svc.setRebootRequired(true);
        }
        return result;
    }

    public native int win32DeleteFile(String var1) throws ServiceException;

    public int deleteDirectory(String directory) throws ServiceException {
        return this.deleteDirectory(directory, true, false);
    }

    public int deleteDirectory(String directory, boolean ifEmpty, boolean includeSubDirs) throws ServiceException {
        SystemUtilService svc;
        String dirName = this.createFileName(this.getCurrentDirectory(), directory);
        if (this.fileExists(dirName) && this.isDirectory(dirName) && this.getParent(dirName) == null) {
            throw new ServiceException(305, "deleteDirectory cannot be used to delete the root directory");
        }
        int result = this.win32DeleteDirectory(directory, ifEmpty, includeSubDirs);
        if (result == 1 && (svc = (SystemUtilService)this.getServices().getService(SystemUtilService.NAME)) != null) {
            svc.setRebootRequired(true);
        }
        return result;
    }

    private native int win32DeleteDirectory(String var1, boolean var2, boolean var3) throws ServiceException;

    public String getNamedDirectory(String directoryName) throws ServiceException {
        boolean stripTrailingSlash = true;
        String result = "";
        if (directoryName.equals(OS_MAIN_DIR)) {
            result = this.win32GetWindowsDirectory();
        } else if (directoryName.equals(OS_VOLUME_DIR)) {
            result = this.getPartitionName(this.win32GetWindowsDirectory(), this.getPartitionNames());
        } else if (directoryName.equals(COMMON_DIR)) {
            result = this.win32GetCommonDirectory();
        } else if (directoryName.equals(IS_VPD_DIR)) {
            result = this.win32GetVPDDirectory();
        } else {
            result = super.getNamedDirectory(directoryName);
            stripTrailingSlash = false;
        }
        if (stripTrailingSlash && CoreFileUtils.getParent(result) != null && (result.endsWith("/") || result.endsWith("\\") || result.endsWith(File.separator))) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    protected native String getLibraryDirectory() throws ServiceException;

    protected native String getStandardInstallDirectory() throws ServiceException;

    protected native String getTempDirectory() throws ServiceException;

    protected native String win32GetWindowsDirectory();

    protected native String win32GetCommonDirectory();

    public native String[] getPartitionNames() throws ServiceException;

    public native long getPartitionFreeSpace(String var1) throws ServiceException;

    public native FileAttributes getFileAttributes(String var1) throws ServiceException;

    public native void setFileAttributes(String var1, FileAttributes var2) throws ServiceException;

    public void setFileExecutable(String file) throws ServiceException {
        File f = new File(file);
        if (!f.isFile()) {
            throw new ServiceException(399, LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32FileServiceImpl.fileDoesNotExist", new String[]{file.toString()}));
        }
    }

    public boolean canRead(String file) {
        boolean abortEnabled = this.win32EnableAbort(false);
        boolean value = super.canRead(file);
        this.win32EnableAbort(abortEnabled);
        return value;
    }

    public native boolean win32EnableAbort(boolean var1);

    public native String getFileOwner(String var1) throws ServiceException;

    public native void setFileOwner(String var1, String var2) throws ServiceException;

    public native String getFileOwnerGroup(String var1) throws ServiceException;

    public native void setFileOwnerGroup(String var1, String var2) throws ServiceException;

    public native boolean supportsLongFileNames(String var1);

    public native boolean isDirectoryWritable(String var1);

    public native int getPartitionType(String var1) throws ServiceException;

    public native String getPartitionFormat(String var1) throws ServiceException;

    private long normalizeDate(long date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1601, 0, 1);
        long nativeTime = calendar.getTime().getTime();
        calendar.set(1970, 0, 1);
        long javaTime = calendar.getTime().getTime();
        return (date + javaTime - nativeTime) * 10000L;
    }

    public void validateFileName(String fileName) throws ServiceException {
        String invalidChars = ":*?\"<>|^!";
        for (int i = 0; i < fileName.length(); ++i) {
            if (invalidChars.indexOf(fileName.charAt(i)) == -1 || fileName.charAt(i) == ':' && i == 1) continue;
            throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "FileServiceImpl.invalidCharacters", new String[]{invalidChars}));
        }
    }

    protected String getPlatformIdImpl() {
        return PLATFORM_ID;
    }

    public void createSymbolicLink(String target, String linkName, boolean forceLink) throws ServiceException {
    }

    protected native String win32GetVPDDirectory();
}

