/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.service.ServiceException;

public class Win32Platform {
    public static final int WINDOWS_ANY = 1;
    public static final int ARCH_ANY = 1;
    public static final int ARCH_X86 = 2;
    public static final int ARCH_IA64 = 3;
    public static final int ARCH_AMD64 = 4;

    public static boolean isCompatibleWith(int nOS, int nArch) throws ServiceException {
        boolean osCompatibility = false;
        boolean archCompatibility = false;
        String osName = System.getProperty("os.name");
        String checkName = "windows";
        if (osName.length() >= checkName.length() && osName.substring(0, checkName.length()).equalsIgnoreCase(checkName)) {
            if (nOS == 1) {
                osCompatibility = true;
            } else {
                throw new ServiceException(399, LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32Platform.unsupportedOSName", new String[]{osName}));
            }
        }
        if (nArch != 1) {
            String arch = System.getProperty("os.arch");
            if (nArch == 2) {
                if (arch.equalsIgnoreCase("x86") || arch.equalsIgnoreCase("i386") || arch.equalsIgnoreCase("i86pc")) {
                    archCompatibility = true;
                }
            } else if (nArch == 3) {
                archCompatibility = arch.equalsIgnoreCase("ia64");
            } else if (nArch == 4) {
                archCompatibility = arch.equalsIgnoreCase("amd64");
            }
        } else {
            archCompatibility = true;
        }
        return osCompatibility && archCompatibility;
    }

    public static boolean targetIsWindowsMachine() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }
}

