/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.win32.Win32RegistryException;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.platform.win32.registry.CreateKeyOperation;
import com.installshield.wizard.platform.win32.registry.DwordValueOperation;
import com.installshield.wizard.platform.win32.registry.HexValueOperation;
import com.installshield.wizard.platform.win32.registry.MultiStringValueOperation;
import com.installshield.wizard.platform.win32.registry.StringValueOperation;
import com.installshield.wizard.service.ServiceException;
import com.zerog.interfaces.util.StringResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class Win32RegistryProcessor {
    private static final int INITIALIZING = 1;
    private static final int READY_FOR_ITEM = 2;
    private static final int REMOVING_ITEM = 3;
    private static final int READING_KEY = 4;
    private static final int READING_VALUE = 5;
    private static final int READING_VALUE_TYPE = 6;
    private static final int READING_STRING_VALUE = 7;
    private static final int READING_DWORD_VALUE = 8;
    private static final int READING_HEX_VALUES = 9;
    private static final int READING_MORE_HEX_VALUES = 10;
    private static final int READING_EXPANDING_STRING_VALUES = 11;
    private static final int READING_MULTI_STRING_VALUES = 12;
    private static final int READING_MORE_EXPANDING_STRING_VALUES = 13;
    private static final int READING_MORE_MULTI_STRING_VALUES = 14;
    private static final int READING_DEFAULT_VALUE = 15;
    private int m_nState = 1;
    private BufferedReader m_br = null;
    private String m_strLine = null;
    private StringTokenizer m_st = null;
    private boolean m_bRemoving = false;
    private String m_strCurrentKey = null;
    private String m_strCurrentParentKey = null;
    private String m_strCurrentChildKey = null;
    private int m_nCurrentHive = -1;
    private String m_strValueName = null;
    private int m_nLine = 0;
    private Vector m_allBytes = null;
    private Win32RegistryService m_registryService = null;
    private StringResolver m_resolver;
    private StringBuffer m_stringInProgress = null;
    private Vector m_multiString = null;
    private Vector operationList = new Vector();
    private boolean manifestLogging = false;

    public Win32RegistryProcessor(String strRegEntries, StringResolver resolver, Win32RegistryService registryService) {
        this.m_br = new BufferedReader(new StringReader(strRegEntries));
        this.m_registryService = registryService;
        this.m_resolver = resolver;
    }

    public Win32RegistryProcessor(File regFile, StringResolver resolver, Win32RegistryService registryService) throws FileNotFoundException, UnsupportedEncodingException {
        InputStreamReader reader = FileUtils.isFileUnicode(regFile) ? new InputStreamReader((InputStream)new FileInputStream(regFile), "UTF-16") : new InputStreamReader(new FileInputStream(regFile));
        this.m_br = new BufferedReader(reader);
        this.m_registryService = registryService;
        this.m_resolver = resolver;
    }

    public Vector process() throws Win32RegistryException {
        try {
            this.m_nState = 1;
            boolean bContinue = this.nextLine();
            boolean bOperationOK = true;
            while (bContinue) {
                switch (this.m_nState) {
                    case 1: {
                        bOperationOK = this.processRegEditHeader();
                        if (bOperationOK) break;
                        bContinue = false;
                        break;
                    }
                    case 2: {
                        this.m_bRemoving = false;
                        bOperationOK = this.processItem();
                        break;
                    }
                    case 3: {
                        this.m_bRemoving = true;
                        bOperationOK = this.processItem();
                        break;
                    }
                    case 4: {
                        bOperationOK = this.processKey();
                        break;
                    }
                    case 5: {
                        bOperationOK = this.processValue();
                        break;
                    }
                    case 15: {
                        bOperationOK = this.processDefaultValue();
                        break;
                    }
                    case 6: {
                        bOperationOK = this.processValueType();
                        break;
                    }
                    case 7: {
                        bOperationOK = this.processStringValue();
                        break;
                    }
                    case 11: {
                        this.initializeStringInProgress();
                        bOperationOK = this.processExpandingStringValue();
                        break;
                    }
                    case 12: {
                        this.m_multiString = new Vector(10);
                        this.initializeStringInProgress();
                        bOperationOK = this.processMultiStringValue();
                        break;
                    }
                    case 13: {
                        bOperationOK = this.processExpandingStringValue();
                        break;
                    }
                    case 14: {
                        bOperationOK = this.processMultiStringValue();
                        break;
                    }
                    case 8: {
                        bOperationOK = this.processDWordValue();
                        break;
                    }
                    case 9: {
                        this.m_allBytes = null;
                        this.m_allBytes = new Vector(20);
                        bOperationOK = this.processHexValues();
                        break;
                    }
                    case 10: {
                        bOperationOK = this.processHexValues();
                    }
                }
                if (!bOperationOK) {
                    this.m_nState = 2;
                }
                if (!bContinue || bOperationOK && this.m_st.hasMoreTokens()) continue;
                bContinue = this.nextLine();
            }
        }
        catch (Win32RegistryException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new Win32RegistryException(ex, this.m_nLine);
        }
        return this.operationList;
    }

    private String getNextToken(String strDelimiters, boolean skipWhitespace) {
        String strToken;
        do {
            try {
                strToken = strDelimiters == null ? this.m_st.nextToken() : this.m_st.nextToken(strDelimiters);
                if (strToken == null || !skipWhitespace) continue;
                strToken = strToken.trim();
            }
            catch (NoSuchElementException ex) {
                strToken = null;
            }
        } while (strToken != null && skipWhitespace && strToken.length() == 0);
        return strToken;
    }

    private boolean nextLine() throws Win32RegistryException {
        try {
            do {
                this.m_strLine = this.m_br.readLine();
                if (this.m_strLine == null) continue;
                this.m_strLine = this.m_resolver.resolveString(this.m_strLine.trim());
                ++this.m_nLine;
            } while (this.m_strLine != null && this.m_strLine.length() == 0);
            if (this.m_strLine != null) {
                this.m_st = null;
                this.m_st = new StringTokenizer(this.m_strLine, " \t", true);
            }
        }
        catch (IOException ex) {
            throw new Win32RegistryException(ex, this.m_nLine);
        }
        return this.m_strLine != null;
    }

    private boolean processRegEditHeader() throws Win32RegistryException {
        boolean bValidFormat = false;
        String strFirstLine = this.m_strLine.trim();
        boolean bl = bValidFormat = strFirstLine.startsWith("REGEDIT") || strFirstLine.startsWith("Windows Registry Editor");
        if (bValidFormat) {
            this.m_nState = 2;
            this.nextLine();
        }
        return bValidFormat;
    }

    private boolean processItem() throws Win32RegistryException {
        String strToken = this.getNextToken("[\"-]@", true);
        if (strToken == null) {
            return false;
        }
        boolean bResult = true;
        if (this.m_nState != 3 && strToken.equals("-")) {
            this.m_nState = 3;
        } else if (strToken.equals("\"")) {
            this.m_nState = 5;
        } else if (strToken.equals("@")) {
            this.m_nState = 15;
        } else if (strToken.equals("[")) {
            this.m_nState = 4;
        } else {
            bResult = false;
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.noClosingQuoteForValueName"), this.m_nLine);
        }
        return bResult;
    }

    private boolean processKey() throws Win32RegistryException, ServiceException {
        boolean bResult = false;
        try {
            this.setCurrentKey(this.getNextToken("]", false));
            String strClosing = this.getNextToken("]", false);
            if (strClosing.equals("]")) {
                if (this.m_bRemoving) {
                    this.m_registryService.deleteKey(this.m_nCurrentHive, this.m_strCurrentParentKey, this.m_strCurrentChildKey, false);
                    this.setCurrentKey(null);
                    bResult = true;
                } else {
                    CreateKeyOperation cko = new CreateKeyOperation(this.m_nCurrentHive, this.m_strCurrentParentKey, this.m_strCurrentChildKey);
                    if (!this.manifestLogging) {
                        cko.install(this.m_registryService);
                    }
                    this.operationList.addElement(cko);
                    bResult = true;
                }
            } else {
                this.setCurrentKey(null);
                throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.invalidKey"), this.m_nLine);
            }
            this.m_nState = 2;
        }
        catch (NoSuchElementException e) {
            bResult = true;
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.invalidKey"), this.m_nLine);
        }
        return bResult;
    }

    private String getQuotedString() {
        boolean bDone = false;
        String strResult = new String("");
        do {
            String strToken;
            if ((strToken = this.getNextToken("\"", false)).equals("\"")) {
                if (strResult.endsWith("\\") && this.m_st.hasMoreTokens()) {
                    String strWorking = strResult;
                    strResult = strWorking.substring(0, strWorking.length() - 1);
                    strResult = strResult + strToken;
                    continue;
                }
                bDone = true;
                continue;
            }
            strResult = strResult + strToken;
        } while (!bDone && this.m_st.hasMoreTokens());
        return bDone ? strResult : null;
    }

    private boolean processDefaultValue() throws Win32RegistryException, ServiceException {
        if (this.m_strCurrentKey == null) {
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.noKeySpecified"), this.m_nLine);
        }
        String strToken = this.getNextToken("=", true);
        if (strToken == null || !strToken.equals("=")) {
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.noEqualAfterValueName", new String[]{"<Default Value>"}), this.m_nLine);
        }
        this.m_strValueName = "";
        this.m_nState = 6;
        return true;
    }

    private boolean processValue() throws Win32RegistryException, ServiceException {
        if (this.m_strCurrentKey == null) {
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.noKeySpecified"), this.m_nLine);
        }
        this.m_strValueName = this.getQuotedString();
        if (this.m_strValueName == null) {
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.noClosingQuoteForValueName"), this.m_nLine);
        }
        String actualValueName = new String(this.m_strValueName);
        if (this.m_strValueName.equals("@")) {
            this.m_strValueName = "";
        }
        if (this.m_bRemoving) {
            this.m_registryService.deleteValue(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, false);
            this.m_nState = 2;
        } else {
            String strToken = this.getNextToken("=", true);
            if (strToken == null || !strToken.equals("=")) {
                throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.noEqualAfterValueName", new String[]{actualValueName}), this.m_nLine);
            }
            this.m_nState = 6;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processValueType() throws Win32RegistryException, ServiceException {
        boolean bResult = false;
        String strDataType = this.getNextToken("\":", true);
        if ((strDataType = strDataType.trim()).equals("\"")) {
            bResult = true;
            this.m_nState = 7;
            return bResult;
        }
        bResult = true;
        String strColon = this.getNextToken(":", true);
        if (!strColon.equals(":")) {
            return false;
        }
        String strLowerDataType = strDataType.toLowerCase();
        if (strLowerDataType.equals("dword")) {
            if (this.m_st.hasMoreTokens()) {
                this.m_nState = 8;
                return bResult;
            }
            bResult = false;
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.noValueAfterDwordType"), this.m_nLine);
        }
        if (strLowerDataType.startsWith("hex(2)")) {
            if (this.m_st.hasMoreTokens()) {
                this.m_nState = 11;
                return bResult;
            }
            StringValueOperation stringValueOp = new StringValueOperation(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, true, "");
            if (!this.manifestLogging) {
                stringValueOp.install(this.m_registryService);
            }
            this.operationList.addElement(stringValueOp);
            this.m_nState = 2;
            return bResult;
        }
        if (strLowerDataType.startsWith("hex(7)")) {
            if (this.m_st.hasMoreTokens()) {
                this.m_nState = 12;
                return bResult;
            }
            MultiStringValueOperation op = new MultiStringValueOperation(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, new String[0]);
            if (!this.manifestLogging) {
                op.install(this.m_registryService);
            }
            this.operationList.addElement(op);
            this.m_nState = 2;
            return bResult;
        }
        if (!strLowerDataType.startsWith("hex")) {
            bResult = false;
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.invalidDataType", new String[]{strDataType}), this.m_nLine);
        }
        if (this.m_st.hasMoreTokens()) {
            this.m_nState = 9;
            return bResult;
        }
        HexValueOperation op = new HexValueOperation(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, new byte[0]);
        if (!this.manifestLogging) {
            op.install(this.m_registryService);
        }
        this.operationList.addElement(op);
        this.m_nState = 2;
        return bResult;
    }

    private boolean processDWordValue() throws Win32RegistryException, ServiceException {
        boolean bResult = true;
        String strToken = this.getNextToken(" \t", true);
        try {
            Long value = Long.valueOf(strToken, 16);
            if (value < 0L || value > 0xFFFFFFFFL) {
                bResult = false;
                throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.dwordValueOutOfRange", new String[]{strToken, new Long(0L).toString(), new Long(0xFFFFFFFFL).toString()}), this.m_nLine);
            }
            DwordValueOperation op = new DwordValueOperation(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, value.intValue());
            if (!this.manifestLogging) {
                op.install(this.m_registryService);
            }
            this.operationList.addElement(op);
        }
        catch (NumberFormatException ex) {
            bResult = false;
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.badFormatForDword", new String[]{strToken}), this.m_nLine);
        }
        this.m_nState = 2;
        return bResult;
    }

    private boolean processHexValues() throws Win32RegistryException, ServiceException {
        boolean bContinue = true;
        boolean bMoreValuesOnNewLine = false;
        do {
            String strHexValue;
            if ((strHexValue = this.getNextToken(" ,\t\\", false)) == null || strHexValue.trim().length() == 0 || strHexValue.equals(",")) continue;
            if (strHexValue.equals("\\")) {
                this.m_nState = 10;
                bMoreValuesOnNewLine = true;
                continue;
            }
            try {
                Integer oneByte = Integer.valueOf(strHexValue, 16);
                if (oneByte < 0 || oneByte > 255) {
                    bContinue = false;
                    throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.hexValueOutOfRange", new String[]{strHexValue, new Integer(0).toString(), new Integer(255).toString()}), this.m_nLine);
                }
                this.m_allBytes.addElement(oneByte);
            }
            catch (NumberFormatException ex) {
                bContinue = false;
                throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.badFormatForHex", new String[]{strHexValue}), this.m_nLine);
            }
        } while (this.m_st.hasMoreTokens() && bContinue);
        if (!bMoreValuesOnNewLine) {
            if (bContinue) {
                byte[] arrayBytes = new byte[this.m_allBytes.size()];
                Enumeration enumer = this.m_allBytes.elements();
                int ii = 0;
                while (enumer.hasMoreElements()) {
                    arrayBytes[ii] = ((Integer)enumer.nextElement()).byteValue();
                    ++ii;
                }
                HexValueOperation op = new HexValueOperation(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, arrayBytes);
                if (!this.manifestLogging) {
                    op.install(this.m_registryService);
                }
                this.operationList.addElement(op);
            }
            this.m_nState = 2;
        }
        return bContinue;
    }

    private boolean processStringValue() throws Win32RegistryException, ServiceException {
        boolean bResult = false;
        String strValue = this.getQuotedString();
        if (strValue == null) {
            throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.noClosingQuoteForString", new String[]{this.m_strValueName, this.m_strCurrentKey}), this.m_nLine);
        }
        boolean bExpandable = strValue.indexOf(37) >= 0;
        StringValueOperation op = new StringValueOperation(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, bExpandable, strValue);
        if (!this.manifestLogging) {
            op.install(this.m_registryService);
        }
        this.operationList.addElement(op);
        bResult = true;
        this.m_nState = 2;
        return bResult;
    }

    private void initializeStringInProgress() {
        this.m_stringInProgress = new StringBuffer(64);
    }

    private boolean processMultiStringValue() throws Win32RegistryException, ServiceException {
        boolean bContinue = true;
        boolean bMoreValuesOnNewLine = false;
        do {
            String strHexValue;
            if ((strHexValue = this.getNextToken(" ,\t\\", false)) == null || strHexValue.trim().length() == 0 || strHexValue.equals(",")) continue;
            if (strHexValue.equals("\\")) {
                this.m_nState = 14;
                bMoreValuesOnNewLine = true;
                continue;
            }
            try {
                Integer oneByte = Integer.valueOf(strHexValue, 16);
                if (oneByte < 0 || oneByte > 255) {
                    bContinue = false;
                    throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.hexValueOutOfRange", new String[]{strHexValue, new Integer(0).toString(), new Integer(255).toString()}), this.m_nLine);
                }
                if (oneByte == 0) {
                    if (!this.m_st.hasMoreTokens()) continue;
                    this.m_multiString.addElement(this.m_stringInProgress.toString());
                    this.initializeStringInProgress();
                    continue;
                }
                this.m_stringInProgress.append((char)oneByte.intValue());
            }
            catch (NumberFormatException ex) {
                bContinue = false;
                throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.badFormatForHex", new String[]{strHexValue}), this.m_nLine);
            }
        } while (this.m_st.hasMoreTokens() && bContinue);
        if (!bMoreValuesOnNewLine) {
            if (bContinue) {
                Object[] multiValue = new String[this.m_multiString.size()];
                this.m_multiString.copyInto(multiValue);
                MultiStringValueOperation op = new MultiStringValueOperation(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, (String[])multiValue);
                if (!this.manifestLogging) {
                    op.install(this.m_registryService);
                }
                this.operationList.addElement(op);
            }
            this.m_nState = 2;
        }
        return bContinue;
    }

    private boolean processExpandingStringValue() throws Win32RegistryException, ServiceException {
        boolean bContinue = true;
        boolean bMoreValuesOnNewLine = false;
        do {
            String strHexValue;
            if ((strHexValue = this.getNextToken(" ,\t\\", false)) == null || strHexValue.trim().length() == 0 || strHexValue.equals(",")) continue;
            if (strHexValue.equals("\\")) {
                this.m_nState = 14;
                bMoreValuesOnNewLine = true;
                continue;
            }
            try {
                Integer oneByte = Integer.valueOf(strHexValue, 16);
                if (oneByte < 0 || oneByte > 255) {
                    bContinue = false;
                    throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.hexValueOutOfRange", new String[]{strHexValue, new Integer(0).toString(), new Integer(255).toString()}), this.m_nLine);
                }
                if (oneByte == 0) continue;
                this.m_stringInProgress.append((char)oneByte.intValue());
            }
            catch (NumberFormatException ex) {
                bContinue = false;
                throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.badFormatForHex", new String[]{strHexValue}), this.m_nLine);
            }
        } while (this.m_st.hasMoreTokens() && bContinue);
        if (!bMoreValuesOnNewLine) {
            if (bContinue) {
                StringValueOperation op = new StringValueOperation(this.m_nCurrentHive, this.m_strCurrentKey, this.m_strValueName, true, this.m_stringInProgress.toString());
                if (!this.manifestLogging) {
                    op.install(this.m_registryService);
                }
                this.operationList.addElement(op);
            }
            this.m_nState = 2;
        }
        return bContinue;
    }

    private void setCurrentKey(String strKey) throws Win32RegistryException {
        if (strKey == null) {
            this.m_strCurrentKey = null;
            this.m_strCurrentParentKey = null;
            this.m_strCurrentChildKey = null;
            this.m_nCurrentHive = -1;
        } else {
            if (strKey.endsWith("\\")) {
                strKey = strKey.substring(0, strKey.length() - 1);
            }
            int pos = strKey.indexOf(92);
            this.m_nCurrentHive = -1;
            String strHive = pos < 0 ? strKey : strKey.substring(0, pos);
            if (strHive.equalsIgnoreCase("HKEY_LOCAL_MACHINE")) {
                this.m_nCurrentHive = 4;
            } else if (strHive.equalsIgnoreCase("HKEY_CLASSES_ROOT")) {
                this.m_nCurrentHive = 1;
            } else if (strHive.equalsIgnoreCase("HKEY_CURRENT_CONFIG")) {
                this.m_nCurrentHive = 2;
            } else if (strHive.equalsIgnoreCase("HKEY_CURRENT_USER")) {
                this.m_nCurrentHive = 3;
            } else if (strHive.equalsIgnoreCase("HKEY_USERS")) {
                this.m_nCurrentHive = 5;
            }
            if (this.m_nCurrentHive != -1) {
                if (pos < 0) {
                    this.m_strCurrentKey = null;
                    this.m_strCurrentParentKey = null;
                    this.m_strCurrentChildKey = null;
                } else {
                    this.m_strCurrentKey = strKey.substring(pos + 1);
                    int posLastSlash = this.m_strCurrentKey.lastIndexOf(92);
                    if (posLastSlash < 0) {
                        this.m_strCurrentChildKey = this.m_strCurrentKey;
                        this.m_strCurrentParentKey = null;
                    } else {
                        this.m_strCurrentChildKey = this.m_strCurrentKey.substring(posLastSlash + 1);
                        this.m_strCurrentParentKey = this.m_strCurrentKey.substring(0, posLastSlash);
                    }
                }
            } else {
                throw new Win32RegistryException(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32RegistryProcessor.invalidRegistryHiveInKey", new String[]{strKey, strHive}), this.m_nLine);
            }
        }
    }

    public Vector getOperationsList() throws Win32RegistryException {
        this.manifestLogging = true;
        return this.process();
    }
}

