/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.win32.Win32Platform;
import com.installshield.wizard.platform.win32.Win32Utils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.security.GroupSpecification;
import com.installshield.wizard.service.security.PureJavaSecurityServiceImpl;
import com.installshield.wizard.service.security.SecurityService;
import com.installshield.wizard.service.security.SecurityServiceImplementor;
import com.installshield.wizard.service.security.UserSpecification;

public class Win32SecurityServiceImpl
extends PureJavaSecurityServiceImpl
implements SecurityServiceImplementor {
    public int getSystemCompatibility() {
        int result = 0;
        try {
            if (Win32Platform.isCompatibleWith(1, 1)) {
                result = 5;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    protected void initialized() {
        super.initialized();
        try {
            Win32Utils.loadDLL(this.getServiceResource(Win32Utils.getJNIDLLResourceName()), Win32Utils.getJNIDLLName());
        }
        catch (Exception ex) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "serviceCannotLoadJniDll", new String[]{SecurityService.NAME, Win32Utils.getJNIDLLName()}));
            ex.printStackTrace();
        }
    }

    public native boolean isCurrentUserAdmin() throws ServiceException;

    public void createUser(UserSpecification userSpec) throws ServiceException {
        String[] args = new String[]{userSpec.getAccountExpirationDate() < 0L ? Long.toString(userSpec.getAccountExpirationDate()) : new Long(userSpec.getAccountExpirationDate() / 1000L).toString(), userSpec.getDescription(), userSpec.getHomeDirectory(), userSpec.getLogonScript(), userSpec.getPassword(), userSpec.getUserFullName(), this.formatUserName(userSpec.getUserName(), userSpec.getAuthority()), userSpec.isAccountDisabled() ? "1" : "0", userSpec.isPasswordChangeRequired() ? "1" : "0"};
        GroupSpecification[] userSpecGroups = userSpec.getGroups();
        String[] associatedGroups = userSpecGroups != null ? new String[userSpecGroups.length] : new String[]{};
        for (int i = 0; i < associatedGroups.length; ++i) {
            GroupSpecification currGroup = userSpecGroups[i];
            associatedGroups[i] = this.formatGroupName(currGroup.getGroupName(), currGroup.getAuthority(), currGroup.getAccountScope());
        }
        this.win32CreateUser(args, associatedGroups);
    }

    private native void win32CreateUser(String[] var1, String[] var2) throws ServiceException;

    public native void deleteUser(String var1) throws ServiceException;

    public void createGroup(GroupSpecification groupSpec) throws ServiceException {
        String resolvedGroupName = this.formatGroupName(groupSpec.getGroupName(), groupSpec.getAuthority(), groupSpec.getAccountScope());
        UserSpecification[] groupSpecUsers = groupSpec.getUsers();
        String[] associatedUsers = groupSpecUsers != null ? new String[groupSpecUsers.length] : new String[]{};
        for (int i = 0; i < associatedUsers.length; ++i) {
            UserSpecification currUser = groupSpecUsers[i];
            associatedUsers[i] = this.formatUserName(currUser.getUserName(), currUser.getAuthority());
        }
        this.win32CreateGroup(resolvedGroupName, associatedUsers);
    }

    public native void win32CreateGroup(String var1, String[] var2) throws ServiceException;

    public native void deleteGroup(String var1) throws ServiceException;

    public void deleteGroup(GroupSpecification groupSpec) throws ServiceException {
        this.deleteGroup(this.formatGroupName(groupSpec.getGroupName(), groupSpec.getAuthority(), groupSpec.getAccountScope()));
    }

    public void deleteUser(UserSpecification userSpec) throws ServiceException {
        this.deleteUser(this.formatUserName(userSpec.getUserName(), userSpec.getAuthority()));
    }

    private String formatUserName(String name, String authority) {
        StringBuffer resolvedName = new StringBuffer();
        if (authority != null && authority.trim().length() > 0) {
            resolvedName.append("\\\\" + authority + "\\");
        }
        resolvedName.append(name);
        return resolvedName.toString();
    }

    private String formatGroupName(String name, String authority, int accountScope) {
        StringBuffer resolvedName = new StringBuffer();
        if (authority != null && authority.trim().length() > 0) {
            resolvedName.append("\\\\" + authority + "\\");
        }
        if (accountScope == 1) {
            resolvedName.append("\\");
        }
        resolvedName.append(name);
        return resolvedName.toString();
    }
}

