/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.win32.Win32Platform;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.platform.win32.Win32ServiceImplementor;
import com.installshield.wizard.platform.win32.Win32Utils;
import com.installshield.wizard.platform.win32.WindowsFixedFileInfo;
import com.installshield.wizard.platform.win32.win32service.NTServiceConfig;
import com.installshield.wizard.platform.win32.win32service.NTServiceStatus;
import com.installshield.wizard.platform.win32.win32service.Win2kServiceFailureActions;
import com.installshield.wizard.platform.win32.win32service.Win2kServiceStatusProcess;
import com.installshield.wizard.service.AbstractServiceImplementor;
import com.installshield.wizard.service.ServiceException;

public class Win32ServiceImpl
extends AbstractServiceImplementor
implements Win32ServiceImplementor {
    public int getSystemCompatibility() {
        int result = 0;
        try {
            if (Win32Platform.isCompatibleWith(1, 1)) {
                result = 5;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    protected void initialized() {
        super.initialized();
        try {
            Win32Utils.loadDLL(this.getServiceResource(Win32Utils.getJNIDLLResourceName()), Win32Utils.getJNIDLLName());
        }
        catch (Exception ex) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "serviceCannotLoadJniDll", new String[]{Win32RegistryService.NAME, Win32Utils.getJNIDLLName()}));
            ex.printStackTrace();
        }
    }

    public native void createNTService(String var1, NTServiceConfig var2) throws ServiceException;

    public native void deleteNTService(String var1) throws ServiceException;

    public native void startNTService(String var1, String[] var2) throws ServiceException;

    public native void changeNTServiceConfig(String var1, NTServiceConfig var2) throws ServiceException;

    public native void changeWin2kServiceDescription(String var1, String var2) throws ServiceException;

    public native void changeWin2kServiceFailureActions(String var1, Win2kServiceFailureActions var2) throws ServiceException;

    public native NTServiceStatus controlNTService(String var1, int var2) throws ServiceException;

    public native NTServiceConfig queryNTServiceConfig(String var1) throws ServiceException;

    public native String queryWin2kServiceDescription(String var1) throws ServiceException;

    public native Win2kServiceFailureActions queryWin2kServiceFailureActions(String var1) throws ServiceException;

    public native String getNTServiceDisplayName(String var1) throws ServiceException;

    public native String getNTServiceKeyName(String var1) throws ServiceException;

    public native String[] enumNTServiceKeys(int var1, int var2) throws ServiceException;

    public native NTServiceStatus queryNTServiceStatus(String var1) throws ServiceException;

    public native Win2kServiceStatusProcess queryWin2kServiceStatusProcess(String var1) throws ServiceException;

    public native boolean serviceExists(String var1) throws ServiceException;

    public native boolean isWin2k() throws ServiceException;

    public native String getShortPath(String var1) throws ServiceException;

    public native WindowsFixedFileInfo getFixedFileInfo(String var1) throws ServiceException;
}

