/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.LockedFilesHandler;
import com.installshield.util.process.ExecuteProcessSupport;
import com.installshield.util.process.ProcessOutputTask;
import com.installshield.wizard.platform.common.environment.EnvironmentVariableManager;
import com.installshield.wizard.platform.common.environment.GenericEnvironmentVariableManager;
import com.installshield.wizard.platform.win32.Win32Platform;
import com.installshield.wizard.platform.win32.Win32Utils;
import com.installshield.wizard.platform.win32.environment.AutoexecEnvironmentVariableManager;
import com.installshield.wizard.platform.win32.environment.ProcessEnvironmentVariableManager;
import com.installshield.wizard.platform.win32.environment.WinMEEnvironmentVariableManager;
import com.installshield.wizard.platform.win32.environment.WinNTEnvironmentVariableManager;
import com.installshield.wizard.platform.win32.environment.WindowsEnvironment;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.PureJavaSystemUtilServiceImpl;
import com.installshield.wizard.service.system.SystemUtilService;
import com.installshield.wizard.service.system.SystemUtilServiceImplementor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

public class Win32SystemUtilServiceImpl
extends PureJavaSystemUtilServiceImpl
implements SystemUtilServiceImplementor,
LockedFilesHandler {
    public static final String EXEC_PROCESS_SW_SHOW_PROPERTY_ID = "win32.process.extra.sw_show";
    public static final String EXEC_PROCESS_WORKGROUP = "win32.process.extra.workgroup";
    public static final int EXEC_PROCESS_SW_SHOWNORMAL = 1;
    public static final int EXEC_PROCESS_SW_SHOWMINIMIZED = 2;
    public static final int EXEC_PROCESS_SW_SHOWMAXIMIZED = 3;
    public static final int EXEC_PROCESS_SW_SHOWHIDDEN = 0;
    String cleanupEXE = "";
    private WinNTEnvironmentVariableManager ntUserEnvVarManager;
    private WinNTEnvironmentVariableManager ntSystemEnvVarManager;
    private WinMEEnvironmentVariableManager meEnvVarManager;
    private static AutoexecEnvironmentVariableManager autoexecEnvVarManager;
    private static boolean autoexecCleanedUp;
    private ProcessEnvironmentVariableManager processEnvVarManager;

    public int getSystemCompatibility() {
        int result = 0;
        try {
            if (Win32Platform.isCompatibleWith(1, 1)) {
                result = 5;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    protected void initialized() {
        super.initialized();
        FileUtils.setLockedFilesHandler(this);
        try {
            Win32Utils.loadDLL(this.getServiceResource(Win32Utils.getJNIDLLResourceName()), Win32Utils.getJNIDLLName());
            this.cleanupEXE = this.writeNativeCleanupEXE();
            CoreFileUtils.clearTempFile(this.cleanupEXE);
        }
        catch (Exception ex) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "serviceCannotLoadJniDll", new String[]{SystemUtilService.NAME, Win32Utils.getJNIDLLName()}));
            ex.printStackTrace();
        }
    }

    public void cleanup() throws ServiceException {
        try {
            if (this.ntUserEnvVarManager != null) {
                this.ntUserEnvVarManager.makeUpdatePersistent();
            }
            if (this.ntSystemEnvVarManager != null) {
                this.ntSystemEnvVarManager.makeUpdatePersistent();
            }
            if (this.meEnvVarManager != null) {
                this.meEnvVarManager.makeUpdatePersistent();
            }
            if (!autoexecCleanedUp) {
                if (autoexecEnvVarManager != null) {
                    autoexecEnvVarManager.makeUpdatePersistent();
                }
                autoexecCleanedUp = true;
            }
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    public void setEnvironmentVariable(String variableName, String variableValue) throws ServiceException {
        this.setEnvironmentVariable(variableName, variableValue, 2);
    }

    public void setEnvironmentVariable(String variableName, String variableValue, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManager mgr = this.getEnvVarManager(level);
        mgr.setVariable(variableName, variableValue);
        this.verifyRebootForEnvironment(mgr);
        this.processEnvVarManager.setVariable(variableName, variableValue);
    }

    public String getEnvironmentVariable(String variableName) throws ServiceException {
        return WindowsEnvironment.getProcessEnvironmentVariable(variableName);
    }

    public String getRawEnvironmentVariable(String variableName, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManager mgr = this.getEnvVarManager(level);
        if (mgr != null) {
            return mgr.getVariable(variableName);
        }
        return null;
    }

    public void deleteEnvironmentVariable(String variableName) throws ServiceException {
        this.deleteEnvironmentVariable(variableName, 2);
    }

    public void deleteEnvironmentVariable(String variableName, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManager mgr = this.getEnvVarManager(level);
        if (mgr != null) {
            mgr.deleteVariable(variableName);
        }
        this.verifyRebootForEnvironment(mgr);
        this.processEnvVarManager.deleteVariable(variableName);
    }

    public void appendEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManager mgr = this.getEnvVarManager(level);
        if (mgr != null) {
            mgr.appendVariable(variableName, variableValue, delimiter);
        }
        this.verifyRebootForEnvironment(mgr);
        this.processEnvVarManager.appendVariable(variableName, variableValue, delimiter);
    }

    public void prependEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManager mgr = this.getEnvVarManager(level);
        if (mgr != null) {
            mgr.prependVariable(variableName, variableValue, delimiter);
        }
        this.verifyRebootForEnvironment(mgr);
        this.processEnvVarManager.prependVariable(variableName, variableValue, delimiter);
    }

    public void unAppendEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManager mgr = this.getEnvVarManager(level);
        if (mgr != null) {
            mgr.unAppendVariable(variableName, variableValue, delimiter);
        }
        this.verifyRebootForEnvironment(mgr);
        this.processEnvVarManager.unAppendVariable(variableName, variableValue, delimiter);
    }

    public void unPrependEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManager mgr = this.getEnvVarManager(level);
        if (mgr != null) {
            mgr.unPrependVariable(variableName, variableValue, delimiter);
        }
        this.verifyRebootForEnvironment(mgr);
        this.processEnvVarManager.unPrependVariable(variableName, variableValue, delimiter);
    }

    public native String getOSServiceLevel() throws ServiceException;

    public native void addSystemStartupCommand(String var1) throws ServiceException;

    public native void removeSystemStartupCommand(String var1) throws ServiceException;

    public native Enumeration systemStartupCommands() throws ServiceException;

    protected void deleteFilesAfterExit() {
        super.deleteFilesAfterExit();
        try {
            this.nativeDeleteFilesAfterExit(this.filesToDeleteOnExit(), this.directoriesToRecursivelyDeleteOnExit(), this.getRebootOnExit(), this.cleanupEXE);
            Enumeration tempFiles = this.filesToDeleteOnExit();
            while (tempFiles.hasMoreElements()) {
                String fileName = (String)tempFiles.nextElement();
                super.removeFileToDeleteOnExit(fileName);
            }
            tempFiles = this.directoriesToRecursivelyDeleteOnExit();
            while (tempFiles.hasMoreElements()) {
                String dirName = (String)tempFiles.nextElement();
                super.removeDirectoryToRecursivelyDeleteOnExit(dirName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private native void nativeDeleteFilesAfterExit(Enumeration var1, Enumeration var2, boolean var3, String var4) throws ServiceException;

    private String writeNativeCleanupEXE() throws IOException {
        do {
            this.cleanupEXE = CoreFileUtils.createFileName(CoreFileUtils.getTempDir(), CoreFileUtils.createTempFileName());
        } while (new File(this.cleanupEXE).exists());
        InputStream in = this.getServiceResource(Win32Utils.getPlatformCleanupResource()).openStream();
        FileOutputStream out = new FileOutputStream(this.cleanupEXE);
        CoreFileUtils.copy(in, out);
        in.close();
        out.close();
        return this.cleanupEXE;
    }

    public native boolean isWinNTor2K();

    public native boolean isWinME();

    public native String getBootDirectory();

    private String getAutoexec() {
        return CoreFileUtils.appendSeparator(this.getBootDirectory()) + "autoexec.bat";
    }

    private void verifyVariableName(String variableName) throws ServiceException {
        if (variableName == null || variableName.length() == 0) {
            throw new ServiceException(399, LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "systemUtil.variableNameRequired"));
        }
    }

    private void verifyRebootForEnvironment(EnvironmentVariableManager mgr) throws ServiceException {
        if (mgr != null && mgr instanceof AutoexecEnvironmentVariableManager) {
            this.setRebootRequired(true);
        }
    }

    private EnvironmentVariableManager getEnvVarManager(int level) throws ServiceException {
        GenericEnvironmentVariableManager mgr = null;
        if (this.processEnvVarManager == null) {
            this.processEnvVarManager = new ProcessEnvironmentVariableManager();
        }
        try {
            if (this.isWinNTor2K()) {
                if (level == 1) {
                    if (this.ntSystemEnvVarManager == null) {
                        this.ntSystemEnvVarManager = new WinNTEnvironmentVariableManager(true);
                        this.ntSystemEnvVarManager.initialize();
                    }
                    mgr = this.ntSystemEnvVarManager;
                } else {
                    if (this.ntUserEnvVarManager == null) {
                        this.ntUserEnvVarManager = new WinNTEnvironmentVariableManager(false);
                        this.ntUserEnvVarManager.initialize();
                    }
                    mgr = this.ntUserEnvVarManager;
                }
            } else if (this.isWinME()) {
                if (this.meEnvVarManager == null) {
                    this.meEnvVarManager = new WinMEEnvironmentVariableManager(this, this.getBootDirectory());
                    this.meEnvVarManager.initialize();
                }
                mgr = this.meEnvVarManager;
            } else {
                if (autoexecEnvVarManager == null) {
                    autoexecEnvVarManager = new AutoexecEnvironmentVariableManager(this, this.getAutoexec());
                    autoexecEnvVarManager.initialize();
                }
                mgr = autoexecEnvVarManager;
            }
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return mgr;
    }

    public void executeProcess(ExecuteProcessSupport execProcSupport, Properties extendedProps) throws ServiceException {
        if (execProcSupport.isRunNatively()) {
            String showWindowProp = extendedProps != null ? extendedProps.getProperty(EXEC_PROCESS_SW_SHOW_PROPERTY_ID) : null;
            int showWindow = showWindowProp != null ? Integer.parseInt(showWindowProp) : 1;
            try {
                ProcessOutputTask stdOutTask = new ProcessOutputTask(execProcSupport.getStdOutputStream(), execProcSupport.getProcessOutputHandler(), 0);
                ProcessOutputTask stdErrTask = new ProcessOutputTask(execProcSupport.getStdErrorStream(), execProcSupport.getProcessOutputHandler(), 1);
                Thread stdOutThread = new Thread(stdOutTask);
                Thread stdErrThread = new Thread(stdErrTask);
                stdOutThread.start();
                stdErrThread.start();
                execProcSupport.setProcessStarted();
                this.nativeExecuteProcess(execProcSupport, showWindow);
                execProcSupport.getStdOutputStream().flush();
                execProcSupport.getStdOutputStream().close();
                execProcSupport.getStdErrorStream().flush();
                execProcSupport.getStdErrorStream().close();
                stdOutThread.join();
                stdErrThread.join();
                execProcSupport.setProcessFinished();
            }
            catch (Exception e) {
                execProcSupport.setProcessError();
                throw new ServiceException(e);
            }
        } else {
            super.executeProcess(execProcSupport, extendedProps);
        }
    }

    private void LogWarning(String message) {
        this.logEvent(this, "wrn", message);
    }

    private native void nativeExecuteProcess(ExecuteProcessSupport var1, int var2) throws ServiceException;

    static {
        autoexecCleanedUp = false;
    }
}

