/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.util.LibraryLoader;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.IOException;
import java.net.URL;

public class Win32Utils {
    public static final String WINDOWS_PRODUCT_ACTION_CATEGORIES = " '/Actions/Platform Specific/Windows' '/Platform Specific/Windows/Actions' ";
    public static final String WINDOWS_WIZARD_ACTION_CATEGORIES = " '/Actions/Platform Specific/Windows' '/Platform Specific/Windows/Actions' ";
    public static final String WINDOWS_CONDITION_CATEGORIES = "'/Platform Specific/Windows'";
    public static final String JVM_VERIFY_CLASS_NAME = "Verify.jar";
    public static final String LAUNCHER_NAME = "LauncherMain.exe";
    public static final String CONSOLE_LAUNCHER_NAME = "ConsoleLauncher.exe";
    public static final String NATIVE_X86_DLL_NAME = "win32ppk.dll";
    public static final String NATIVE_IA64_DLL_NAME = "win64ppk.dll";
    public static final String NATIVE_AMD64_DLL_NAME = "winamd64ppk.dll";
    public static final String ISJECLN_NAME = "isjecln.exe";
    public static final String IA64_SUB_DIR = "ia64/";
    public static final String AMD64_SUB_DIR = "amd64/";
    private static final String PPK_BUILD_SUB_DIR = "win32ppk/";
    private static final String CLASS_RESOURCE_DIR = "reslib/windowsppk/";

    public static void loadDLL(URL dll, String name) {
        try {
            if (System.getProperty("is.debug") != null) {
                System.out.println("Loading DLL " + dll);
            }
            LibraryLoader.loadLibrary(dll, name);
        }
        catch (Throwable ex) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32Utils.cannotLoadJniDll", new String[]{dll.toString()}));
            ex.printStackTrace();
        }
    }

    public static String getWindowsPPKBuildSubdir() {
        return PPK_BUILD_SUB_DIR;
    }

    public static String getVerifyClassBuildResource() {
        return Win32Utils.getWindowsPPKBuildSubdir() + JVM_VERIFY_CLASS_NAME;
    }

    public static String getWin32LauncherBuildResource() {
        return Win32Utils.getWindowsPPKBuildSubdir() + LAUNCHER_NAME;
    }

    public static String getWin32ConsoleLauncherBuildResource() {
        return Win32Utils.getWindowsPPKBuildSubdir() + CONSOLE_LAUNCHER_NAME;
    }

    public static String getWindowsIA64LauncherBuildResource() {
        return Win32Utils.getWindowsPPKBuildSubdir() + IA64_SUB_DIR + LAUNCHER_NAME;
    }

    public static String getWindowsIA64ConsoleLauncherBuildResource() {
        return Win32Utils.getWindowsPPKBuildSubdir() + IA64_SUB_DIR + CONSOLE_LAUNCHER_NAME;
    }

    public static String getWindowsAMD64LauncherBuildResource() {
        return Win32Utils.getWindowsPPKBuildSubdir() + AMD64_SUB_DIR + LAUNCHER_NAME;
    }

    public static String getWindowsAMD64ConsoleLauncherBuildResource() {
        return Win32Utils.getWindowsPPKBuildSubdir() + AMD64_SUB_DIR + CONSOLE_LAUNCHER_NAME;
    }

    public static String getClassResourceSubdir() {
        return CLASS_RESOURCE_DIR;
    }

    public static String getBitmode() {
        String bitMode = System.getProperty("sun.arch.data.model");
        if (bitMode != null) {
            return bitMode;
        }
        return System.getProperty("com.ibm.vm.bitmode");
    }

    public static String getJNIDLLName() {
        String arch = System.getProperty("os.arch");
        if ("ia64".equalsIgnoreCase(arch)) {
            return NATIVE_IA64_DLL_NAME;
        }
        if ("amd64".equalsIgnoreCase(arch) && "64".equals(Win32Utils.getBitmode())) {
            return NATIVE_AMD64_DLL_NAME;
        }
        return NATIVE_X86_DLL_NAME;
    }

    public static String getJNIDLLResourceName() {
        String arch = System.getProperty("os.arch");
        if ("ia64".equalsIgnoreCase(arch)) {
            return Win32Utils.getClassResourceSubdir() + IA64_SUB_DIR + Win32Utils.getJNIDLLName();
        }
        if ("amd64".equalsIgnoreCase(arch) && "64".equals(Win32Utils.getBitmode())) {
            return Win32Utils.getClassResourceSubdir() + AMD64_SUB_DIR + Win32Utils.getJNIDLLName();
        }
        return Win32Utils.getClassResourceSubdir() + Win32Utils.getJNIDLLName();
    }

    public static String getPlatformLauncherResource() {
        if (System.getProperty("os.arch").equalsIgnoreCase("ia64")) {
            return Win32Utils.getClassResourceSubdir() + IA64_SUB_DIR + LAUNCHER_NAME;
        }
        return Win32Utils.getClassResourceSubdir() + LAUNCHER_NAME;
    }

    public static String getWin32LauncherResource() {
        return Win32Utils.getClassResourceSubdir() + LAUNCHER_NAME;
    }

    public static String getWin32ConsoleLauncherResource() {
        return Win32Utils.getClassResourceSubdir() + CONSOLE_LAUNCHER_NAME;
    }

    public static String getWindowsIA64LauncherResource() {
        return Win32Utils.getClassResourceSubdir() + IA64_SUB_DIR + LAUNCHER_NAME;
    }

    public static String getWindowsIA64ConsoleLauncherResource() {
        return Win32Utils.getClassResourceSubdir() + IA64_SUB_DIR + CONSOLE_LAUNCHER_NAME;
    }

    public static String getWindowsAMD64LauncherResource() {
        return Win32Utils.getClassResourceSubdir() + AMD64_SUB_DIR + LAUNCHER_NAME;
    }

    public static String getWindowsAMD64ConsoleLauncherResource() {
        return Win32Utils.getClassResourceSubdir() + AMD64_SUB_DIR + CONSOLE_LAUNCHER_NAME;
    }

    public static String getVerifyClassResource() {
        return Win32Utils.getClassResourceSubdir() + JVM_VERIFY_CLASS_NAME;
    }

    public static String getPlatformCleanupResource() {
        if (System.getProperty("os.arch").equalsIgnoreCase("ia64")) {
            return Win32Utils.getClassResourceSubdir() + IA64_SUB_DIR + ISJECLN_NAME;
        }
        return Win32Utils.getClassResourceSubdir() + ISJECLN_NAME;
    }

    public static int registerDLL(SystemUtilService sysUtilSvc, String filePath, boolean deferRegistration) throws IOException, InterruptedException, ServiceException {
        int nResult = -1;
        String path = "\"" + filePath + "\"";
        if (!deferRegistration) {
            String[] cmdArray = new String[]{"regsvr32.exe", "/s", path};
            Process process = Runtime.getRuntime().exec(cmdArray);
            process.waitFor();
            nResult = process.exitValue();
        } else {
            String cmdLine = "regsvr32.exe /s " + path;
            sysUtilSvc.addSystemStartupCommand(cmdLine);
            nResult = 0;
        }
        return nResult;
    }

    public static int unregisterDLL(SystemUtilService sysUtilSvc, String filePath, boolean deferUnregistration) throws IOException, InterruptedException, ServiceException {
        int nResult = -1;
        String path = "\"" + filePath + "\"";
        if (!deferUnregistration) {
            String[] cmdArray = new String[]{"regsvr32.exe", "/u", "/s", path};
            Process process = Runtime.getRuntime().exec(cmdArray);
            process.waitFor();
            nResult = process.exitValue();
        } else {
            String cmdLine = "regsvr32.exe /u /s " + path;
            sysUtilSvc.addSystemStartupCommand(cmdLine);
            nResult = 0;
        }
        return nResult;
    }
}

