/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.environment;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.regex.RegexUtil;
import com.installshield.wizard.platform.common.environment.ScriptEnvironmentVariableManager;
import com.installshield.wizard.platform.win32.Win32SystemUtilServiceImpl;
import com.zerog.interfaces.util.regex.RegExprSyntaxException;
import java.io.File;

public class AutoexecEnvironmentVariableManager
extends ScriptEnvironmentVariableManager {
    private Win32SystemUtilServiceImpl systemUtilSvc = null;

    public AutoexecEnvironmentVariableManager(Win32SystemUtilServiceImpl systemUtilSvc, String autoexecPath) {
        super(autoexecPath);
        this.systemUtilSvc = systemUtilSvc;
    }

    public String getCommentString() {
        return "REM";
    }

    public void setVariable(String variableName, String variableValue) {
        super.setVariable(variableName, variableValue);
        try {
            this.systemUtilSvc.setRebootRequired(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteVariable(String variableName) {
        super.deleteVariable(variableName);
        try {
            this.systemUtilSvc.setRebootRequired(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String writeVariable(String variableName, String valueWithEcho, String valueWithoutEcho) {
        StringBuffer scriptLine = new StringBuffer();
        if (valueWithEcho.equals(valueWithoutEcho)) {
            scriptLine.append("SET " + variableName + "=" + valueWithEcho + ScriptEnvironmentVariableManager.lineSeparator);
        } else {
            scriptLine.append("if x" + this.getEchoCommandString(variableName) + "x == xx GOTO NO_" + variableName + ScriptEnvironmentVariableManager.lineSeparator);
            scriptLine.append("SET " + variableName + "=" + valueWithEcho + ScriptEnvironmentVariableManager.lineSeparator);
            scriptLine.append("GOTO END_" + variableName + ScriptEnvironmentVariableManager.lineSeparator);
            scriptLine.append(":NO_" + variableName + ScriptEnvironmentVariableManager.lineSeparator);
            scriptLine.append("SET " + variableName + "=" + valueWithoutEcho + ScriptEnvironmentVariableManager.lineSeparator);
            scriptLine.append(":END_" + variableName + ScriptEnvironmentVariableManager.lineSeparator);
        }
        return scriptLine.toString();
    }

    protected String getEchoCommandString(String variableName) {
        return "%" + variableName + "%";
    }

    protected String getBackupFileName(String parent, String file) {
        String fileNoExt = file;
        int dotIndex = file.lastIndexOf(".");
        if (dotIndex >= 0) {
            fileNoExt = file.substring(0, dotIndex);
        }
        int backupNo = this.getCurrentBackupLevel(parent, fileNoExt);
        return CoreFileUtils.createFileName(parent, fileNoExt + "." + (backupNo + 1));
    }

    private int getCurrentBackupLevel(String parent, String fileNoExt) {
        int max = 0;
        String rex = fileNoExt + "\\.[0-9]+";
        String[] files = new File(parent).list();
        try {
            for (int i = 0; i < files.length; ++i) {
                int index;
                if (!RegexUtil.getInstance().matches(files[i], rex) || (index = files[i].lastIndexOf(".")) < 0) continue;
                try {
                    int backupLevel = Integer.parseInt(files[i].substring(index + 1));
                    if (backupLevel <= max) continue;
                    max = backupLevel;
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        catch (RegExprSyntaxException ex2) {
            // empty catch block
        }
        return max;
    }
}

