/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.environment;

import com.installshield.boot.CoreFileUtils;
import com.installshield.wizard.platform.common.environment.GenericEnvironmentVariableManager;
import com.installshield.wizard.platform.win32.Win32SystemUtilServiceImpl;
import com.installshield.wizard.platform.win32.environment.WindowsEnvironment;
import com.installshield.wizard.service.ServiceException;

public class WinMEEnvironmentVariableManager
extends GenericEnvironmentVariableManager {
    private Win32SystemUtilServiceImpl systemUtilSvc = null;
    private String winSystemDir = "";
    private static final String ENVIRONMENT_KEY = "System\\CurrentControlSet\\Control\\SessionManager\\Environment";

    public WinMEEnvironmentVariableManager(Win32SystemUtilServiceImpl systemUtilSvc, String winSystemDir) {
        this.systemUtilSvc = systemUtilSvc;
        this.winSystemDir = winSystemDir;
    }

    protected void initializeImpl() {
    }

    public void makeUpdatePersistent() {
        String regenvCmd = CoreFileUtils.appendSeparator(this.winSystemDir) + "regenv32 -" + this.winSystemDir.charAt(0) + "2";
        try {
            if (System.getProperty("is.debug") != null) {
                System.out.println("Executing " + regenvCmd);
            }
            Process process = Runtime.getRuntime().exec(regenvCmd);
            int result = process.waitFor();
            if (System.getProperty("is.debug") != null) {
                System.out.println("  Result = " + result);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getEchoCommandString(String variableName) {
        return "";
    }

    public String getCommentString() {
        return "";
    }

    public boolean variableExists(String variableName) {
        try {
            return WindowsEnvironment.winMEGetRawEnvironmentVariable(variableName) != null;
        }
        catch (ServiceException serviceException) {
            return false;
        }
    }

    public void setVariable(String variableName, String variableValue) {
        try {
            WindowsEnvironment.winMESetEnvironmentVariable(variableName, variableValue);
            this.systemUtilSvc.setRebootRequired(true);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    public void deleteVariable(String variableName) {
        try {
            WindowsEnvironment.winMESetEnvironmentVariable(variableName, null);
            this.systemUtilSvc.setRebootRequired(true);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    public String getVariable(String variableName) {
        try {
            return WindowsEnvironment.winMEGetRawEnvironmentVariable(variableName);
        }
        catch (ServiceException serviceException) {
            return null;
        }
    }
}

