/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.environment;

import com.installshield.wizard.platform.common.environment.GenericEnvironmentVariableManager;
import com.installshield.wizard.platform.win32.environment.WindowsEnvironment;
import com.installshield.wizard.service.ServiceException;

public class WinNTEnvironmentVariableManager
extends GenericEnvironmentVariableManager {
    private boolean systemLevel = false;

    public WinNTEnvironmentVariableManager(boolean systemLevel) {
        this.systemLevel = systemLevel;
    }

    protected void initializeImpl() {
    }

    public void makeUpdatePersistent() {
    }

    public String getEchoCommandString(String variableName) {
        return "";
    }

    public String getCommentString() {
        return "";
    }

    public boolean variableExists(String variableName) {
        try {
            return WindowsEnvironment.winNTGetRawEnvironmentVariable(variableName, this.systemLevel) != null;
        }
        catch (ServiceException serviceException) {
            return false;
        }
    }

    public void setVariable(String variableName, String variableValue) {
        try {
            WindowsEnvironment.winNTSetEnvironmentVariable(variableName, variableValue, this.systemLevel);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    public void deleteVariable(String variableName) {
        try {
            WindowsEnvironment.winNTSetEnvironmentVariable(variableName, null, this.systemLevel);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    public String getVariable(String variableName) {
        try {
            return WindowsEnvironment.winNTGetRawEnvironmentVariable(variableName, this.systemLevel);
        }
        catch (ServiceException serviceException) {
            return null;
        }
    }
}

