/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.registry;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizard.platform.win32.Win32RegistryException;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.platform.win32.registry.Win32RegistryOperation;
import com.installshield.wizard.service.ServiceException;

public class CreateKeyOperation
implements Win32RegistryOperation,
PropertyAccessible {
    private int hive = -1;
    private String parentKey = null;
    private String childKey = null;

    public CreateKeyOperation() {
    }

    public CreateKeyOperation(int hive, String parentKey, String childKey) {
        this.hive = hive;
        this.parentKey = parentKey;
        this.childKey = childKey;
    }

    public void install(Win32RegistryService registryService) throws Win32RegistryException, ServiceException {
        registryService.createKey(this.hive, this.parentKey, this.childKey);
    }

    public void unInstall(Win32RegistryService registryService) throws Win32RegistryException, ServiceException {
        if (registryService.keyExists(this.hive, this.parentKey + "\\" + this.childKey) && registryService.isKeyEmpty(this.hive, this.parentKey + "\\" + this.childKey)) {
            registryService.deleteKey(this.hive, this.parentKey, this.childKey, false);
        }
    }

    public void setHive(int hive) {
        this.hive = hive;
    }

    public int getHive() {
        return this.hive;
    }

    public void setParentKey(String key) {
        this.parentKey = key;
    }

    public String getParentKey() {
        return this.parentKey;
    }

    public void setChildKey(String key) {
        this.childKey = key;
    }

    public String getChildKey() {
        return this.childKey;
    }
}

