/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.registry;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizard.platform.win32.Win32RegistryException;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.platform.win32.registry.Win32RegistryOperation;
import com.installshield.wizard.service.ServiceException;

public class DwordValueOperation
implements Win32RegistryOperation,
PropertyAccessible {
    private int currentHive = -1;
    private String currentKey = null;
    private String valueName = null;
    private int currentValue = -1;
    private int oldValue = -1;

    public DwordValueOperation() {
    }

    public DwordValueOperation(int hive, String key, String name, int value) {
        this.currentHive = hive;
        this.currentKey = key;
        this.valueName = name;
        this.currentValue = value;
    }

    public void install(Win32RegistryService registryService) throws Win32RegistryException, ServiceException {
        try {
            if (registryService.valueExists(this.currentHive, this.currentKey, this.valueName)) {
                this.oldValue = registryService.get32BitValue(this.currentHive, this.currentKey, this.valueName);
            }
        }
        catch (Exception e) {
            this.oldValue = -1;
        }
        registryService.set32BitValue(this.currentHive, this.currentKey, this.valueName, this.currentValue);
    }

    public void unInstall(Win32RegistryService registryService) throws Win32RegistryException, ServiceException {
        int valueInRegistry;
        if (registryService.valueExists(this.currentHive, this.currentKey, this.valueName) && (valueInRegistry = registryService.get32BitValue(this.currentHive, this.currentKey, this.valueName)) == this.currentValue) {
            if (this.oldValue == -1) {
                registryService.deleteValue(this.currentHive, this.currentKey, this.valueName, false);
            } else {
                registryService.set32BitValue(this.currentHive, this.currentKey, this.valueName, this.oldValue);
            }
        }
    }

    public void setCurrentHive(int hive) {
        this.currentHive = hive;
    }

    public int getCurrentHive() {
        return this.currentHive;
    }

    public void setCurrentKey(String key) {
        this.currentKey = key;
    }

    public String getCurrentKey() {
        return this.currentKey;
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public String getValueName() {
        return this.valueName;
    }

    public void setCurrentValue(int value) {
        this.currentValue = value;
    }

    public int getCurrentValue() {
        return this.currentValue;
    }

    public void setOldValue(int value) {
        this.oldValue = value;
    }

    public int getOldValue() {
        return this.oldValue;
    }
}

