/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.registry;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizard.platform.win32.Win32RegistryException;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.platform.win32.registry.Win32RegistryOperation;
import com.installshield.wizard.service.ServiceException;

public class HexValueOperation
implements Win32RegistryOperation,
PropertyAccessible {
    private int currentHive = -1;
    private String currentKey;
    private String valueName;
    private byte[] currentValue = null;
    private byte[] oldValue = null;

    public HexValueOperation() {
    }

    public HexValueOperation(int hive, String key, String name, byte[] value) {
        this.currentHive = hive;
        this.currentKey = key;
        this.valueName = name;
        this.currentValue = value;
    }

    public void install(Win32RegistryService registryService) throws Win32RegistryException, ServiceException {
        try {
            if (registryService.valueExists(this.currentHive, this.currentKey, this.valueName)) {
                this.oldValue = registryService.getBinaryValue(this.currentHive, this.currentKey, this.valueName);
            }
        }
        catch (Exception e) {
            this.oldValue = null;
        }
        registryService.setBinaryValue(this.currentHive, this.currentKey, this.valueName, this.currentValue);
    }

    public void unInstall(Win32RegistryService registryService) throws Win32RegistryException, ServiceException {
        byte[] valueInRegistry;
        if (registryService.valueExists(this.currentHive, this.currentKey, this.valueName) && this.compareValue(valueInRegistry = registryService.getBinaryValue(this.currentHive, this.currentKey, this.valueName), this.currentValue)) {
            if (this.oldValue == null) {
                registryService.deleteValue(this.currentHive, this.currentKey, this.valueName, false);
            } else {
                registryService.setBinaryValue(this.currentHive, this.currentKey, this.valueName, this.oldValue);
            }
        }
    }

    private boolean compareValue(byte[] first, byte[] second) {
        if (first.length != second.length) {
            return false;
        }
        boolean same = true;
        for (int ii = 0; same && ii < second.length; ++ii) {
            if (first[ii] == second[ii]) continue;
            same = false;
        }
        return same;
    }

    public void setCurrentHive(int hive) {
        this.currentHive = hive;
    }

    public int getCurrentHive() {
        return this.currentHive;
    }

    public void setCurrentKey(String key) {
        this.currentKey = key;
    }

    public String getCurrentKey() {
        return this.currentKey;
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public String getValueName() {
        return this.valueName;
    }

    public void setCurrentValue(byte[] value) {
        this.currentValue = value;
    }

    public byte[] getCurrentValue() {
        return this.currentValue;
    }

    public void setOldValue(byte[] value) {
        this.oldValue = value;
    }

    public byte[] getOldValue() {
        return this.oldValue;
    }
}

