/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.registry;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizard.platform.win32.Win32RegistryException;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.platform.win32.registry.Win32RegistryOperation;
import com.installshield.wizard.service.ServiceException;

public class MultiStringValueOperation
implements Win32RegistryOperation,
PropertyAccessible {
    private int currentHive = -1;
    private String currentKey;
    private String valueName;
    private boolean expandable = false;
    private String[] multiValue = null;
    private String[] oldValue = null;

    public MultiStringValueOperation() {
    }

    public MultiStringValueOperation(int hive, String key, String name, String[] value) {
        this.currentHive = hive;
        this.currentKey = key;
        this.valueName = name;
        this.multiValue = value;
    }

    public void install(Win32RegistryService registryService) throws Win32RegistryException, ServiceException {
        try {
            if (registryService.valueExists(this.currentHive, this.currentKey, this.valueName)) {
                this.oldValue = registryService.getMultiStringValue(this.currentHive, this.currentKey, this.valueName);
            }
        }
        catch (Exception e) {
            this.oldValue = null;
        }
        registryService.setMultiStringValue(this.currentHive, this.currentKey, this.valueName, this.multiValue);
    }

    public void unInstall(Win32RegistryService registryService) throws Win32RegistryException, ServiceException {
        String[] valueInRegistry;
        if (registryService.valueExists(this.currentHive, this.currentKey, this.valueName) && this.compareValue(valueInRegistry = registryService.getMultiStringValue(this.currentHive, this.currentKey, this.valueName), this.multiValue)) {
            if (this.oldValue == null) {
                registryService.deleteValue(this.currentHive, this.currentKey, this.valueName, false);
            } else {
                registryService.setMultiStringValue(this.currentHive, this.currentKey, this.valueName, this.oldValue);
            }
        }
    }

    private boolean compareValue(String[] first, String[] second) {
        if (first.length != second.length) {
            return false;
        }
        boolean retVal = true;
        for (int i = 0; i < first.length; ++i) {
            if (first[i].equals(second[i])) continue;
            retVal = false;
        }
        return retVal;
    }

    public void setCurrentHive(int hive) {
        this.currentHive = hive;
    }

    public int getCurrentHive() {
        return this.currentHive;
    }

    public void setCurrentKey(String key) {
        this.currentKey = key;
    }

    public String getCurrentKey() {
        return this.currentKey;
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public String getValueName() {
        return this.valueName;
    }

    public void setMultiValue(String[] value) {
        this.multiValue = value;
    }

    public String[] getMultiValue() {
        return this.multiValue;
    }

    public void setOldValue(String[] value) {
        this.oldValue = value;
    }

    public String[] getOldValue() {
        return this.oldValue;
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }
}

