/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.registry;

import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.platform.win32.registry.Win32RegistryValueConverter;
import com.installshield.wizard.service.ServiceException;

public class RegistryUtils {
    public static String getRegistryValueAsString(Win32RegistryService regsvc, Win32RegistryValueConverter converter, int hive, String key, String valueName, boolean expandStringValue) throws ServiceException {
        String value = "";
        if (regsvc.valueExists(hive, key, valueName)) {
            int valueType = regsvc.getValueType(hive, key, valueName);
            if (valueType == 3) {
                byte[] binaryValue = regsvc.getBinaryValue(hive, key, valueName);
                if (binaryValue != null) {
                    value = converter.convertToString(binaryValue);
                }
            } else if (valueType == 4) {
                int dwordValue = regsvc.get32BitValue(hive, key, valueName);
                value = converter.convertToString(dwordValue);
            } else if (valueType == 2) {
                String exStringValue = regsvc.getStringValue(hive, key, valueName, expandStringValue);
                value = converter.convertToString(exStringValue);
            } else if (valueType == 7) {
                String[] multiStringValue = regsvc.getMultiStringValue(hive, key, valueName);
                value = converter.convertToString(multiStringValue);
            } else if (valueType == 1) {
                String stringValue = regsvc.getStringValue(hive, key, valueName, false);
                value = converter.convertToString(stringValue);
            }
        }
        return value;
    }
}

