/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.registry;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizard.platform.win32.Win32RegistryException;
import com.installshield.wizard.platform.win32.Win32RegistryService;
import com.installshield.wizard.platform.win32.registry.Win32RegistryOperation;
import com.installshield.wizard.service.ServiceException;

public class StringValueOperation
implements Win32RegistryOperation,
PropertyAccessible {
    private int currentHive = -1;
    private String currentKey;
    private String valueName;
    private boolean expandable = false;
    private String currentValue = null;
    private String oldValue = null;

    public StringValueOperation() {
    }

    public StringValueOperation(int hive, String key, String name, boolean isExpandable, String value) {
        this.currentHive = hive;
        this.currentKey = key;
        this.valueName = name;
        this.expandable = isExpandable;
        this.currentValue = value;
    }

    public void install(Win32RegistryService registryService) throws Win32RegistryException, ServiceException {
        try {
            if (registryService.valueExists(this.currentHive, this.currentKey, this.valueName)) {
                this.oldValue = registryService.getStringValue(this.currentHive, this.currentKey, this.valueName, this.expandable);
            }
        }
        catch (Exception e) {
            this.oldValue = null;
        }
        registryService.setStringValue(this.currentHive, this.currentKey, this.valueName, this.expandable, this.currentValue);
    }

    public void unInstall(Win32RegistryService registryService) throws Win32RegistryException, ServiceException {
        String valueInRegistry;
        if (registryService.valueExists(this.currentHive, this.currentKey, this.valueName) && (valueInRegistry = registryService.getStringValue(this.currentHive, this.currentKey, this.valueName, false)).equals(this.currentValue)) {
            if (this.oldValue == null) {
                registryService.deleteValue(this.currentHive, this.currentKey, this.valueName, false);
            } else {
                registryService.setStringValue(this.currentHive, this.currentKey, this.valueName, this.expandable, this.oldValue);
            }
        }
    }

    public void setCurrentHive(int hive) {
        this.currentHive = hive;
    }

    public int getCurrentHive() {
        return this.currentHive;
    }

    public void setCurrentKey(String key) {
        this.currentKey = key;
    }

    public String getCurrentKey() {
        return this.currentKey;
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public String getValueName() {
        return this.valueName;
    }

    public void setCurrentValue(String value) {
        this.currentValue = value;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setOldValue(String value) {
        this.oldValue = value;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }
}

